package com.arms.api.analysis.resource.model.vo.horizontalbar;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

import java.util.List;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class HorizontalBarChartYAxisAndSeriesVO {

    @JsonProperty("name")
    String name;

    @JsonProperty("yaxisVO")
    HorizontalBarChartYAxisVO yAxisVO;

    @JsonProperty("series")
    List<HorizontalBarChartSeriesVO> series;

    @Getter
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class HorizontalBarChartYAxisVO {
        String type;
        List<String> data;
    }

    @Getter
    @Builder
    @NoArgsConstructor
    @AllArgsConstructor
    public static class HorizontalBarChartSeriesVO {

        String name;
        String type;
        List<Long> data;

        String accountId;
        String emailAddress;
    }
}
