package com.arms.api.analysis.scope.model.vo;

import com.arms.egovframework.javaservice.treeframework.excel.ExcelClassAnnotation;
import com.arms.egovframework.javaservice.treeframework.excel.ExcelFieldAnnotation;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

import java.util.List;

@AllArgsConstructor
@NoArgsConstructor
@Builder
@Getter

@ExcelClassAnnotation(sheetName = "Sheet2", headerRowSize = 1, headerTitleName = "요구사항 및 연결된 이슈 분포")
public class NetworkChartExcelDataVO {

    @ExcelFieldAnnotation(columnIndex = 0, headerName = "생성 일")
    private String createDate;

    @ExcelFieldAnnotation(columnIndex = 1, headerName = "버전 정보")
    private String versionNameList;

    private List<Long> pdServiceVersions;

    @ExcelFieldAnnotation(columnIndex = 2, headerName = "A-RMS 요구사항 이슈 키")
    private String key;

    @ExcelFieldAnnotation(columnIndex = 3, headerName = "이슈 타입")
    private String issueType;

    @ExcelFieldAnnotation(columnIndex = 4, headerName = "A-RMS 요구사항 이슈")
    private String summary;


    @ExcelFieldAnnotation(columnIndex = 5, headerName = "( 하위 / 연결 ) 이슈 개수")
    private String subTaskAndLinkedIssueCount;

    private int subTaskCount;

    private int linkedIssueCount;

    @Builder
    public NetworkChartExcelDataVO(String createDate, String versionNameList, List<Long> pdServiceVersions,
                                   String key, String issueType, String summary, int subTaskCount, int linkedIssueCount) {
        this.createDate = createDate;
        this.versionNameList = versionNameList;
        this.pdServiceVersions = pdServiceVersions;
        this.key = key;
        this.issueType = issueType;
        this.summary = summary;
        this.subTaskCount = subTaskCount;
        this.linkedIssueCount = linkedIssueCount;
        this.subTaskAndLinkedIssueCount = String.format("( %d / %d )", subTaskCount, linkedIssueCount);
    }
}
