package com.arms.api.product_service.pdserviceversion.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class PdServiceVersionVO {
    private Long c_id;
    private String c_title;
    private String c_pds_version_start_date;
    private String c_pds_version_end_date;

    public static PdServiceVersionVO toVO(PdServiceVersionEntity pdServiceVersionEntity) {
        return PdServiceVersionVO.builder()
                .c_id(pdServiceVersionEntity.getC_id())
                .c_title(pdServiceVersionEntity.getC_title())
                .build();
    }

    public static PdServiceVersionVO toVOWithDate(PdServiceVersionEntity pdServiceVersionEntity) {
        return PdServiceVersionVO.builder()
                .c_id(pdServiceVersionEntity.getC_id())
                .c_title(pdServiceVersionEntity.getC_title())
                .c_pds_version_start_date(pdServiceVersionEntity.getC_pds_version_start_date())
                .c_pds_version_end_date(pdServiceVersionEntity.getC_pds_version_end_date())
                .build();
    }
}
