package com.arms.api.util.communicate.external;

import com.arms.api.analysis.cost.model.dto.CalculationCostDTO;
import com.arms.api.analysis.time.model.dto.TimeDTO;
import com.arms.api.analysis.time.model.vo.HeatMapVO;
import com.arms.api.analysis.time.model.vo.ScatterChartVO;
import com.arms.api.backoffice.config.esindex.model.vo.IndexStatusSumVO;
import com.arms.api.backoffice.config.esindex.model.vo.IndexStatusesWithJobIdVO;
import com.arms.api.backoffice.information.timeoff.model.vo.UsersInfoVO;
import com.arms.api.blog.model.BlogDTO;
import com.arms.api.blog.model.BlogVO;
import com.arms.api.clientcase.model.ClientCaseDTO;
import com.arms.api.jira.jiraserver.model.AlmAccount;
import com.arms.api.newsletter.model.NewsletterContentsDTO;
import com.arms.api.report.fulldata.model.FullDataRequestDTO;
import com.arms.api.report.fulldata.model.FullDataResponseDTO;
import com.arms.api.report.fulldata.model.작업자_정보;
import com.arms.api.report.mail.modal.vo.AssigneeIssueCountVO;
import com.arms.api.requirement.reqadd.model.dto.RequirementDTO;
import com.arms.api.requirement.reqadd.model.vo.RequirementVO;
import com.arms.api.requirement.reqstatus.model.HierarchicalAlmIssue;
import com.arms.api.requirement.reqstatus.model.SubtaskAndLinkedIssuesRequestDTO;
import com.arms.api.requirement.reqstatus_calendar.model.ReqStatusCalendarRequestDTO;
import com.arms.api.requirement.reqstatus_calendar.model.ReqStatusCalendarResponseDTO;
import com.arms.api.util.communicate.external.request.ServerInfo;
import com.arms.api.util.communicate.external.request.증분이슈수집RequestDTO;
import com.arms.api.util.communicate.external.response.jira.*;
import com.arms.api.wiki.model.WikiContentsDTO;
import com.arms.api.wiki.model.WikiVersionsVO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

@FeignClient(name = "engine", url = "${arms.engine.url}")
public interface EngineService {
    /*
    * ALM Server
    * */
    @PostMapping("/engine/serverInfo")
    ServerInfoEntity registerOrUpdateAlmServerInfo(@RequestBody ServerInfo serverInfo);

    @GetMapping("/engine/serverInfo/listByConnectIds")
    List<ServerInfo> serverInfoListByConnectIds(@RequestParam("connectIds") List<String> connectIds);

    /*
     * 공통
     */
    @PostMapping("/{connectId}/jira/issue")
    public 지라이슈_데이터 이슈_생성하기(
            @PathVariable("connectId") Long 연결_아이디,
            @RequestBody 지라이슈생성_데이터 지라이슈생성_데이터
    );

    @PutMapping("/{connectId}/jira/issue/{issueKeyOrId}")
    public Map<String, Object> 이슈_수정하기(
            @PathVariable("connectId") Long 연결_아이디,
            @PathVariable("issueKeyOrId") String 이슈_키_또는_아이디,
            @RequestBody 지라이슈생성_데이터 지라이슈생성_데이터
    );

    @DeleteMapping("/{connectId}/jira/issue/{issueKeyOrId}")
    public Map<String, Object> 이슈_삭제하기(
            @PathVariable("connectId") Long 연결_아이디,
            @PathVariable("issueKeyOrId") String 이슈_키_또는_아이디
    );

    @GetMapping("/{connectId}/jira/project/list")
    public List<지라프로젝트_데이터> ALM_프로젝트_목록_가져오기(@PathVariable("connectId") String 연결_아이디);

    @GetMapping("/{connectId}/jira/issuetype/list")
    public List<지라이슈유형_데이터> ALM_이슈_유형_가져오기(@PathVariable("connectId") String 연결_아이디);

    @GetMapping("/{connectId}/jira/issuepriority/list")
    public List<지라이슈우선순위_데이터> ALM_이슈_우선순위_가져오기(@PathVariable("connectId") String 연결_아이디);

    @GetMapping("/{connectId}/jira/issueresolution/list")
    public List<지라이슈해결책_데이터> ALM_이슈_해결책_가져오기(@PathVariable("connectId") String 연결_아이디);

    @GetMapping("/{connectId}/jira/issuestatus/list")
    public List<지라이슈상태_데이터> ALM_이슈_상태_가져오기(@PathVariable("connectId") String 연결_아이디);

    @GetMapping("/engine/jira/{connectId}/issue/search/{issueKey}/subAndLinks")
    public List<AlmIssue> 지라_연결된이슈_서브테스크_가져오기(@PathVariable("connectId") Long 연결_아이디,
                                                @PathVariable("issueKey") String 이슈_키,
                                                @RequestParam("page") int 페이지_번호,
                                                @RequestParam("size") int 페이지_사이즈);

    @GetMapping("/engine/serverInfo/serverTypeMap")
    public Map<String,String> 서버_연결아이디_유형정보_맵_조회();

    /*
     * 클라우드
     */
    @GetMapping("/{connectId}/jira/issuetype/project/{projectId}")
    public List<지라이슈유형_데이터> 클라우드_프로젝트별_이슈_유형_목록(@PathVariable("connectId") String 연결_아이디,
                                                @PathVariable("projectId") String 프로젝트_아이디);

    @GetMapping("/{connectId}/jira/issuestatus/project/{projectId}")
    public List<클라우드_지라_이슈유형별_상태_데이터> 클라우드_프로젝트별_이슈_상태_목록(@PathVariable("connectId") String 연결_아이디,
                                                @PathVariable("projectId") String 프로젝트_아이디);

    /*
     * 검색엔진
     */
    @GetMapping("/engine/jira/{connectId}/issue/loadToES/bulk/{issueKey}")
    AlmIssue 이슈수집(
            @PathVariable("connectId") Long 지라서버_아이디,
            @PathVariable("issueKey") String 이슈_키,
            @RequestParam("pdServiceId") Long 제품서비스_아이디,
            @RequestParam("pdServiceVersions") Long[] 버전_아이디_배열,
            @RequestParam("cReqLink") Long cReqLink,
            @RequestParam("projectKeyOrId") String 프로젝트키_또는_아이디,
            @SpringQueryMap CReqProperty CReqProperty
    );

    @PostMapping("/engine/jira/issue/loadToES/bulk/increment")
    void 증분이슈수집(@RequestBody 증분이슈수집RequestDTO 증분이슈수집RequestDTO);

    @PostMapping("/engine/jira/{connectId}/issue/pre-process/req-status-to-es")
    void saveRequirementIssueKeyOnlyFirst(
            @PathVariable("connectId") String 지라서버_아이디,
            @RequestParam("cTitle") String cTitle,
            @RequestParam("cReqStatusId") Long cReqStatusId,
            @RequestParam("issueKey") String 이슈_키,
            @RequestParam("pdServiceId") Long 제품서비스_아이디,
            @RequestParam("pdServiceVersions") Long[] 버전_아이디_배열,
            @RequestParam("cReqLink") Long cReqLink,
            @RequestParam("projectKeyOrId") String 프로젝트키_또는_아이디,
            @SpringQueryMap CReqProperty CReqProperty
    );

    @PostMapping("/engine/jira/sync-data/delete-if-does-not-exist-doc")
    void deleteIfDoesNotExistDoc();


    /*
     * 요구사항 상세 페이지
     */
    @GetMapping("/engine/jira/{connectId}/issue/getReqCount/{pdServiceId}")
    Map<String, Long> 제품서비스별_담당자_요구사항_통계(@PathVariable("connectId") Long 지라서버_아이디,
                                            @PathVariable("pdServiceId") Long 제품서비스_아이디,
                                            @RequestParam("assigneeEmail") String 담당자_이메일);

    @GetMapping("/engine/jira/{connectId}/issue/getReqCount/{pdServiceId}/{issueKey}")
    Map<String, Long> 제품서비스별_담당자_연관된_요구사항_통계(@PathVariable("connectId") Long 지라서버_아이디,
                                                @PathVariable("pdServiceId") Long 제품서비스_아이디,
                                                @PathVariable("issueKey") String 이슈키,
                                                @RequestParam("assigneeEmail") String 담당자_이메일);

    /*
     * 이슈 가져오기.
     */
    @GetMapping("/engine/jira/{connectId}/issue/get/{reqProjectKey}/{reqIssueKey}")
    AlmIssue 요구사항이슈_조회(@PathVariable("connectId") Long 지라서버_아이디,
                            @PathVariable("reqProjectKey") String 지라프로젝트_키,
                            @PathVariable("reqIssueKey") String 지라이슈_키);

    @GetMapping("/engine/reqStatus/deletedIssueList")
    ResponseEntity<List<AlmIssue>> getDeletedIssueList(
            @RequestParam("pdServiceLink") Long pdServiceLink,
            @RequestParam("pdServiceVersionLinks") List<Long> pdServiceVersionLink
    );

    @PutMapping("/engine/reqStatus/deleteWithdrawal")
    ResponseEntity<?> 이슈삭제_철회(@RequestBody List<AlmIssue> AlmIssue);


    @GetMapping("/alm/account/verify")
    ResponseEntity<AlmAccount> verifyAccount(@SpringQueryMap ServerInfo serverInfo);

    /*
     *  요구사항 별 담당자
     * */
    @PostMapping("/engine/jira/dashboard/req-assignees")
    ResponseEntity<List<RequirementVO>> 제품_요구사항_담당자(
            @RequestBody RequirementDTO requirementDTO
    );

    /*
     *  요구사항 상태 변경
     * */
    @PutMapping("/{connectId}/jira/issue/{issueKeyOrId}/{statusId}")
    public Map<String, Object> 이슈_상태_변경하기(
            @PathVariable("connectId") Long 연결_아이디,
            @PathVariable("issueKeyOrId") String 이슈_키_또는_아이디,
            @PathVariable("statusId") String 요구사항_이슈_타입
    );

    /*
    *  요구사항 묶음 조회(함께 생성된 요구사항 이슈 모두 조회)
    * */
    @GetMapping("/engine/reqStatus/reqIssues-created-together")
    ResponseEntity<List<AlmIssue>> 요구사항_묶음_조회(
            @RequestParam("pdServiceId") Long pdServiceLink,
            @RequestParam("pdServiceVersions") Long[] pdServiceVersionLinks,
            @RequestParam("cReqLink") Long 요구사항_아이디);

    /*
     *  리포트 - Full Data 메뉴
     * */

    // 작업자 정보
    @GetMapping("/engine/report/resource-list")
    ResponseEntity<List<작업자_정보>> getAssigneeList();

    // 이슈목록 가져오기
    @GetMapping("/engine/report/issue-list")
    ResponseEntity<FullDataResponseDTO> 이슈목록_가져오기(@SpringQueryMap FullDataRequestDTO fullDataRequestDTO);

    // 이슈목록 가져오기
    @GetMapping("/engine/report/issue-list-calendar")
    ResponseEntity<ReqStatusCalendarResponseDTO> 이슈목록_가져오기_calendar(@SpringQueryMap ReqStatusCalendarRequestDTO reqStatusCalendarRequestDTO);

    // 이슈목록 가져오기
    @GetMapping("/engine/report/issue-list-scroll-api")
    ResponseEntity<FullDataResponseDTO> 이슈목록_가져오기_스크롤API(@SpringQueryMap FullDataRequestDTO fullDataRequestDTO);

    /*
    * AnalysisTime - 기본검색 API
    * */
    // AnalysisTime
    @PostMapping("/engine/analysis-time/updated-issue/heatmap-data")
    ResponseEntity<HeatMapVO> getHeatMapDataByUpdated(@RequestBody TimeDTO timeDTO);

    @PostMapping("/engine/analysis-time/updated-issue/scatter-data")
    ResponseEntity<List<ScatterChartVO>> getScatterData(@RequestBody TimeDTO timeDTO);

    @GetMapping("/engine/report/req-issue-list")
    ResponseEntity<FullDataResponseDTO> getReqIssueList(@SpringQueryMap FullDataRequestDTO fullDataRequestDTO);

    @GetMapping("/engine/report/assignee-report")
    ResponseEntity<AssigneeIssueCountVO> getAssigneeAggregationList(@SpringQueryMap FullDataRequestDTO fullDataRequestDTO);

    @GetMapping("/engine/index/es-index/sum-list")
    ResponseEntity<CommonResponse.ApiResult<List<IndexStatusSumVO>>> esIndexSumList();

    @GetMapping("/engine/index/index-status/histories")
    ResponseEntity<CommonResponse.ApiResult<List<IndexStatusesWithJobIdVO>>> indexJobHistories();

    /*
    * ReqStatus - 이슈 목록 조회
    * */
    @PostMapping("/engine/reqStatus/issue-list-by-pd")
    List<AlmIssue> issueListByPd(@RequestBody RequirementDTO requirementDTO);

    // 삭제 예정 (tab2)
    @PostMapping("/engine/reqStatus/issueListByUpdatedDate")
    ResponseEntity<List<AlmIssue>> issueListByUpdatedDate(@RequestBody RequirementDTO requirementDTO);
    // tab1
    @PostMapping("/engine/reqStatus/issue-list-by-updated")
    List<HierarchicalAlmIssue> issueListByUpdated(@RequestBody RequirementDTO requirementDTO);
    // tab2
    @PostMapping("/engine/reqStatus/issue-list-by-updated-2nd")
    ResponseEntity<List<AlmIssue>> issueListByUpdated2ndTab(@RequestBody RequirementDTO requirementDTO);
    //issueListByOverallUpdatedDate
    @PostMapping("/engine/reqStatus/issueListByOverallUpdatedDate")
    ResponseEntity<List<AlmIssue>> issueListByOverallUpdatedDate(@RequestBody RequirementDTO requirementDTO);
    //
    @PostMapping("/engine/reqStatus/subtasks-and-linked-issues")
    List<HierarchicalAlmIssue> subtasksAndLinkedIssues(@RequestBody SubtaskAndLinkedIssuesRequestDTO subtaskAndLinkedIssuesRequestDTO);

    /*
    *  Backoffice - Time off
    * */
    @GetMapping("/engine/backoffice/timeoff/getUsersInfo")
    ResponseEntity<List<UsersInfoVO>> getUsersInfo();

    /*
     * WIKI
     * */
    @GetMapping("/engine/wiki/{wikiId}")
    ResponseEntity<CommonResponse.ApiResult<WikiContentsDTO>> getWiki(@PathVariable("wikiId") String wikiId);

    @GetMapping("/engine/wiki/{wikiId}/{version}")
    ResponseEntity<CommonResponse.ApiResult<WikiContentsDTO>> getWiki(@PathVariable("wikiId") String wikiId, @PathVariable("version") Long version);

    @GetMapping("/engine/wiki/version/{wikiId}")
    ResponseEntity<CommonResponse.ApiResult<WikiVersionsVO>> getWikiVersions(@PathVariable("wikiId") String wikiId, @RequestParam("size") int size, @RequestParam("page") int page);

    @PostMapping("/engine/wiki/create")
    ResponseEntity<String> createWiki(@RequestBody WikiContentsDTO wikiContentsDTO);

    @PutMapping("/engine/wiki/update")
    ResponseEntity<String> updateWiki(@RequestBody WikiContentsDTO wikiContentsDTO);

    @PutMapping("/engine/wiki/change-recent")
    ResponseEntity<CommonResponse.ApiResult<String>> changeRecent(@RequestBody WikiContentsDTO wikiContentsDTO);

    @DeleteMapping("/engine/wiki/{wikiId}")
    ResponseEntity<CommonResponse.ApiResult<String>> deleteWiki(@PathVariable("wikiId") String wikiId);

    @PostMapping("/engine/analysis-cost/calculation-cost")
    ResponseEntity<?> calculationCost(@RequestBody CalculationCostDTO calculationCostDTO);

    /*
     * BLOG
     * */
    @PostMapping("/engine/blog/get")
    ResponseEntity<BlogDTO> getBlog(@RequestBody BlogDTO blogDTO);

    @PostMapping("/engine/blog")
    ResponseEntity<Long> addBlog(@RequestBody BlogDTO blogDTO);

    @PutMapping("/engine/blog")
    ResponseEntity<Long> updateBlog(@RequestBody BlogDTO blogDTO);

    @DeleteMapping("/engine/blog/{c_id}")
    ResponseEntity<Long> deleteBlog(@PathVariable("c_id") String c_id);

    @PostMapping("/engine/blog/popular")
    ResponseEntity<List<BlogDTO>> getBlogListByViewCountDesc(@RequestBody BlogDTO blogDTO);

    @PostMapping("/engine/blog/search")
    ResponseEntity<BlogVO> getBlogListBySearchAfter(@RequestBody BlogDTO blogDTO);

    /*
     * NEWSLETTER
     * */
    @PostMapping("/engine/newsletter/addNewsletter")
    ResponseEntity<CommonResponse.ApiResult<NewsletterContentsDTO>> addNewsletter(@RequestBody NewsletterContentsDTO newsletterContentsDTO);

    @GetMapping("/engine/newsletter/{newsletterId}")
    ResponseEntity<CommonResponse.ApiResult<NewsletterContentsDTO>> getNewsletter(@PathVariable("newsletterId") String newsletterId);

    @PutMapping("/engine/newsletter/updateNewsletter")
    ResponseEntity<CommonResponse.ApiResult<NewsletterContentsDTO>> updateNewsletter(@RequestBody NewsletterContentsDTO newsletterContentsDTO);

    @DeleteMapping("/engine/newsletter/{newsletterId}")
    ResponseEntity<CommonResponse.ApiResult<NewsletterContentsDTO>> deleteNewsletter(@PathVariable("newsletterId") String newsletterId);

    /*
     * ClientCase Contents
     * */
    @GetMapping("/engine/clientcase/{clientCaseId}")
    ResponseEntity<ClientCaseDTO> getClientCase(@PathVariable("clientCaseId") String clientCaseId);

    @PostMapping("/engine/clientcase")
    ResponseEntity<String> addClientCase(@RequestBody Map<String, Object> clientCaseData);

    @PutMapping("/engine/clientcase")
    ResponseEntity<String> updateClientCase(@RequestBody Map<String, Object> clientCaseData);

    @DeleteMapping("/engine/clientcase/{clientCaseId}")
    ResponseEntity<String> deleteClientCase(@PathVariable("clientCaseId") String clientCaseId);

    /*
     * POC
     * */
    @GetMapping("/engine/poc/{id}")
    ResponseEntity<CommonResponse.ApiResult<com.arms.api.poc.model.PocEntity>> getPoc(@PathVariable("id") String id);

    @PostMapping("/engine/poc")
    ResponseEntity<CommonResponse.ApiResult<String>> createPoc(@RequestBody com.arms.api.poc.model.PocDTO pocDTO);

    @GetMapping("/engine/poc")
    ResponseEntity<CommonResponse.ApiResult<com.arms.api.poc.model.vo.PocVO>> getPocList(@SpringQueryMap com.arms.api.poc.model.PocDTO pocDTO);

    @PutMapping("/engine/poc/{id}")
    ResponseEntity<CommonResponse.ApiResult<String>> updatePoc(@PathVariable("id") String id, @RequestBody com.arms.api.poc.model.PocDTO pocDTO);

    @DeleteMapping("/engine/poc/{id}")
    ResponseEntity<CommonResponse.ApiResult<String>> deletePoc(@PathVariable("id") String id);
    
}
