package com.arms.api.analysis.scope.controller;

import com.arms.api.analysis.scope.model.dto.ScopeDTO;
import com.arms.api.analysis.scope.model.vo.*;
import com.arms.api.analysis.scope.service.ScopeService;
import com.arms.api.util.model.dto.PdServiceAndIsReqDTO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.util.StringUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping(value = "/admin/arms/analysis/scope")
@RequiredArgsConstructor
public class ScopeController {

    private final ScopeService scopeService;

    /*
    * 네트워크 차트 - 요구사항 및 연결된 이슈 분포 전체 데이터 조회
    * */
    @PostMapping(value = "/{changeReqTableName}/issue-network")
    public ResponseEntity<NetworkChartVO> getReqNetworkFullData(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                                @RequestBody ScopeDTO scopeDTO) throws Exception {

        log.info(" [ ScopeController :: getReqNetworkFullData ] ");
        NetworkChartVO result = scopeService.getReqNetworkFullData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok(result);
    }

    /*
     * 네트워크 차트 - 요구사항 및 연결된 이슈 분포 버전 데이터 조회
     * */
    @PostMapping(value = "/getReqNetworkVersionData/{changeReqTableName}/getReqAddListByFilter")
    public ResponseEntity<NetworkChartVO> getReqNetworkVersionData(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                                    @RequestBody ScopeDTO scopeDTO) throws Exception {

        log.info(" [ ScopeController :: getReqNetworkVersionData ] ");
        NetworkChartVO result = scopeService.getReqNetworkVersionData(changeReqTableName,scopeDTO);
        return ResponseEntity.ok(result);
    }

    /*
     * 네트워크 차트 - 요구사항 및 연결된 이슈 분포 버전 데이터 조회
     * */
    @PostMapping(value = "/getReqNetworkIssueData/{changeReqTableName}/getReqAddListByFilter")
    public ResponseEntity<NetworkChartVO> getReqNetworkIssueData(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                                @RequestBody ScopeDTO scopeDTO) throws Exception {

        log.info(" [ ScopeController :: getReqNetworkIssueData ] ");
        NetworkChartVO result = scopeService.getReqNetworkIssueData(changeReqTableName, scopeDTO);
        return ResponseEntity.ok(result);
    }


    @GetMapping(value = "/getReqNetworkFilterData/{changeReqTableName}/getReqAddListByFilter")
    public ResponseEntity<List<TreeNodeVO>> getReqNetworkFilterData(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                                    @RequestParam("pdServiceId") Long pdServiceId,
                                                                    @RequestParam("pdServiceVersionLinks") List<Long> pdServiceVersionLink) throws Exception {

        log.info(" [ ScopeController :: getReqNetworkFilterData ] ");

        PdServiceAndIsReqDTO pdServiceAndIsReqDTO = new PdServiceAndIsReqDTO();
        pdServiceAndIsReqDTO.setPdServiceLink(pdServiceId);
        pdServiceAndIsReqDTO.setPdServiceVersionLinks(pdServiceVersionLink);

        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setPdServiceAndIsReq(pdServiceAndIsReqDTO);

        List<TreeNodeVO> result = scopeService.getReqNetworkFilterData(changeReqTableName,scopeDTO);
        return ResponseEntity.ok(result);
    }

    @PostMapping("/req-per-version/{changeReqTableName}/getReqAddListByFilter")
    public ResponseEntity<?> countByVersionNames(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                @RequestBody ScopeDTO scopeDTO) throws Exception {

        String pdServiceStr = StringUtils.replace(changeReqTableName, "T_ARMS_REQADD_", "");
        log.info("[ ScopeController :: countByVersionNames ] :: countByVersionNames.pdServiceId ==> {}, pdServiceVersionLinks ==> {}"
                , pdServiceStr, scopeDTO.getPdServiceAndIsReq().getPdServiceVersionLinks());

        List<CountByVersionNamesVO> countByVersionNamesVOS = scopeService.countByVersionNames(changeReqTableName, scopeDTO);

        return ResponseEntity.ok(CommonResponse.success(countByVersionNamesVOS));

    }
    /*
    * 요구사항 및 요구사항 항목(우선순위|난이도|상태) 데이터 테이블
    * */
    @GetMapping("/{changeReqTableName}/req-property-list")
    public ResponseEntity<List<ReqAddWithPropertyVO>> reqAddWithPropertyListPerVersion(
                            @PathVariable(value = "changeReqTableName") String changeReqTableName,
                            @RequestParam("pdServiceId") Long pdServiceId,
                            @RequestParam("pdServiceVersionLinks") List<Long> pdServiceVersionLink) throws Exception {

        log.info("[ ScopeController :: reqAddWithPropertyListPerVersion ] :: changeReqTableName ==> {} pdServiceId ==> {}, pdServiceVersionLinks ==> {}"
                , changeReqTableName, pdServiceId ,pdServiceVersionLink);

        return ResponseEntity.ok(scopeService.reqAddWithPropertyListPerVersion(changeReqTableName, pdServiceId, pdServiceVersionLink));
    }

    /* 요구사항 데이터 테이블 */
    @GetMapping("/getDataTableIssues")
    public ResponseEntity<List<ReqDataTableIssuesVO>> getDataTableIssues(@RequestParam("pdServiceId") Long pdServiceId,
                                                                        @RequestParam("pdServiceVersionLinks") List<Long> pdServiceVersionLink,
                                                                        @RequestParam("startDate") String startDate,
                                                                        @RequestParam("endDate") String endDate

    ) throws Exception {

        PdServiceAndIsReqDTO pdServiceAndIsReqDTO = new PdServiceAndIsReqDTO();
        pdServiceAndIsReqDTO.setPdServiceLink(pdServiceId);
        pdServiceAndIsReqDTO.setPdServiceVersionLinks(pdServiceVersionLink);

        ScopeDTO scopeDTO = new ScopeDTO();
        scopeDTO.setPdServiceAndIsReq(pdServiceAndIsReqDTO);

        scopeDTO.setStartDate(startDate);
        scopeDTO.setEndDate(endDate);

        return ResponseEntity.ok(scopeService.getDataTableIssues(scopeDTO));

    }

    // circular-packing
    @PostMapping("/getCircularPackingChartData/{changeReqTableName}/getReqAddListByFilter")
    public ResponseEntity<?> getCircularPackingChartData(@PathVariable(value = "changeReqTableName") String changeReqTableName,
                                                        @RequestBody ScopeDTO scopeDTO) throws Exception {

        List<CircularPackingChartVO> result = scopeService.getCircularPackingChartData(changeReqTableName, scopeDTO);

        return ResponseEntity.ok(CommonResponse.success(result));

    }

    // treeBarData
    @PostMapping("/tree-bar-data")
    public ResponseEntity<CommonResponse.ApiResult<List<TreeBarVO>>> reqTreeBarData(@RequestBody ScopeDTO scopeDTO) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(scopeService.treeBarData(scopeDTO)));
    }


    @PostMapping("/getNetworkChartExcelData")
    public ResponseEntity<?> getNetworkChartExcelDataVO(@RequestBody ScopeDTO scopeDTO) throws Exception {
        return ResponseEntity.ok(CommonResponse.success(scopeService.getNetworkChartExcelData(scopeDTO)));
    }


}
