package com.arms.api.newsletter.controller;

import com.arms.api.newsletter.model.NewsletterDTO;
import com.arms.api.newsletter.model.NewsletterEntity;
import com.arms.api.newsletter.service.Newsletter;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import com.arms.egovframework.javaservice.treeframework.controller.TreeAbstractController;
import com.arms.egovframework.javaservice.treeframework.validation.group.AddNode;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.PostConstruct;

@Slf4j
@Controller
@RestController
@RequiredArgsConstructor
@RequestMapping(value = {"/anonymous/cover/newsletter"})
public class NewsletterController extends TreeAbstractController<Newsletter, NewsletterDTO, NewsletterEntity> {

    private final Newsletter newsletter;

    @PostConstruct
    public void initialize() {
        setTreeService(newsletter);
        setTreeEntity(NewsletterEntity.class);
    }

    @PostMapping("/addNewsletter")
    public ResponseEntity<?> addNewsletter(@Validated({AddNode.class}) NewsletterDTO newsletterDTO) throws Exception {
        log.info("[ NewsletterController :: addNewsletter ]");

        NewsletterEntity newsletterEntity = modelMapper.map(newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok(CommonResponse.success(newsletter.addNewsletter(newsletterEntity)));
    }

    @GetMapping("/getNewsletter/{newsletterId}")
    public ResponseEntity<?> getNewsletter(@PathVariable("newsletterId") Long newsletterId) throws Exception {
        log.info("[ NewsletterController :: getNewsletter ]");

        return ResponseEntity.ok(newsletter.getNewsletter(newsletterId));
    }

    @PutMapping("/updateNewsletter")
    public ResponseEntity<?> updateNewsletter(NewsletterDTO newsletterDTO) throws Exception {
        log.info("[ NewsletterController :: updateNewsletter ]");

        NewsletterEntity newsletterEntity = modelMapper.map(newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok(CommonResponse.success(newsletter.updateNewsletter(newsletterEntity)));
    }

    @DeleteMapping("/removeNewsletter/{newsletterId}")
    public ResponseEntity<?> removeNewsletter(@PathVariable("newsletterId") Long newsletterId) throws Exception {
        log.info("[ NewsletterController :: removeNewsletter ]");

        return ResponseEntity.ok(CommonResponse.success(newsletter.removeNewsletter(newsletterId)));
    }

    @GetMapping("/getNewsletters")
    public ResponseEntity<?> getNewsletters(
            NewsletterDTO newsletterDTO,
            @RequestParam int pageIndex,
            @RequestParam int pageUnit) throws Exception {
        log.info("[ NewsletterController :: getNewsletters ]");

        NewsletterEntity newsletterEntity = modelMapper.map(newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok(newsletter.getNewsletters(newsletterEntity, pageIndex, pageUnit));
    }

    @GetMapping("/getPopularNewsletters")
    public ResponseEntity<?> getPopularNewsletters(
            NewsletterDTO newsletterDTO,
            @RequestParam int pageIndex,
            @RequestParam int pageUnit) throws Exception {
        log.info("[ NewsletterController :: getPopularNewsletters ]");

        NewsletterEntity newsletterEntity = modelMapper.map(newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok(newsletter.getPopularNewsletters(newsletterEntity, pageIndex, pageUnit));
    }

    @GetMapping("/countNewsletters")
    public ResponseEntity<?> countNewsletters(NewsletterDTO newsletterDTO) throws Exception {
        log.info("[ NewsletterController :: countNewsletters ]");

        NewsletterEntity newsletterEntity = modelMapper.map(newsletterDTO, NewsletterEntity.class);
        return ResponseEntity.ok(newsletter.getNewsletterCount(newsletterEntity));
    }
}

// TODO: 권한 관련한 부분 추가 필요