package com.arms.api.report.export_service.service;

import com.arms.api.report.export_service.enums.ExportType;
import com.arms.api.report.export_service.model.ReportData;

/**
 * 리포트 내보내기 서비스 인터페이스
 *
 * <p><b>PPT, PDF 등</b> 다양한 형식의 서비스가 구현합니다.</p>
 *
 * @author HS.Yang
 * @since 25.12.03
 */
public interface ReportExportService {

    /**
     * 리포트 내보내기
     *
     * @param data 리포트 데이터
     * @return 바이트 배열
     */
    byte[] export(ReportData data);

    /**
     * 내보내기 타입 반환
     */
    ExportType getExportType();

    /**
     * 파일 확장자 반환
     */
    default String getFileExtension() {
        return getExportType().getExtension();
    }

    /**
     * Content-Type 반환
     */
    default String getContentType() {
        return getExportType().getContentType();
    }

    /**
     * 타입 지원 여부
     */
    default boolean supports(ExportType type) {
        return getExportType() == type;
    }
}