package com.arms.api.util;

import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.cloud.context.environment.EnvironmentChangeEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

//@RefreshScope
@Component
@Getter
@Setter
@Slf4j
public class GlobalConfig implements ApplicationListener<EnvironmentChangeEvent> {

    // 설정 변경된 내용을 actuator를 통해 변경값을 갱신
//    @Value("${global.config.test}")
    private String configTest;

    private final Environment environment;

    public GlobalConfig(Environment environment) {
        this.environment = environment;
    }

    @Override
    public void onApplicationEvent(EnvironmentChangeEvent event) {
        log.info("=== EnvironmentChangeEvent 발생 ===");
        log.info("변경된 키 목록: {}", event.getKeys());

        // 특정 키가 변경되었는지 확인
        if (event.getKeys().contains("global.config.test")) {
            String newValue = environment.getProperty("global.config.test");
            log.info("🔄 global.config.test 변경 감지!");
            log.info("   현재 @Value 필드 값: {}", configTest);
            log.info("   Environment에서 읽은 새 값: {}", newValue);
        }
    }

    public String getConfigTest() {
        return configTest;
    }
}
