package com.arms.api.util.communicate.external;

import com.arms.api.util.communicate.external.request.redis.AlmDataRequestDTO;
import com.arms.api.util.communicate.external.request.redis.ArmsStateCategoryDTO;
import com.arms.api.util.communicate.external.request.redis.ArmsStateDTO;
import com.arms.egovframework.javaservice.treeframework.controller.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

@FeignClient(name = "middle-proxy", url = "${arms.middle-proxy.url}")
public interface MiddleProxyService {
    @PostMapping("/mapping/alm/issuestatus")
    CommonResponse.ApiResult<String> setAlmIssueStatusDTO(@RequestBody AlmDataRequestDTO almDataRequestDTO);

    @PostMapping("/mapping/state")
    CommonResponse.ApiResult<String> setArmsState(@RequestBody List<ArmsStateDTO> armsStateDTOs);

    @PostMapping("/mapping/category")
    CommonResponse.ApiResult<String> setArmsStateCategory(@RequestBody List<ArmsStateCategoryDTO> armsStateCategoryDTOs);
}