/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.requirement.controller;

import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.requirement.model.dto.RequirementAggrDTO;
import com.arms.api.requirement.model.dto.RequirementDTO;
import com.arms.api.requirement.model.dto.SubtaskAndLinkedIssuesRequestDTO;
import com.arms.api.requirement.model.vo.HierarchicalAlmIssue;
import com.arms.api.requirement.model.vo.ReqProgressVO;
import com.arms.api.requirement.model.vo.RequirementVO;
import com.arms.api.requirement.service.RequirementService;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engine"})
public class RequirementController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequirementController.class);
    @Autowired
    private RequirementService requirementService;

    @PostMapping(value={"/jira/dashboard/req-assignees"})
    public ResponseEntity<List<RequirementVO>> \uc81c\ud488_\uc694\uad6c\uc0ac\ud56d\ubcc4_\ub2f4\ub2f9\uc790_\ubaa9\ub85d(@RequestBody RequirementAggrDTO requirementAggrDTO) {
        return ResponseEntity.ok(this.requirementService.\uc81c\ud488_\uc694\uad6c\uc0ac\ud56d\ubcc4_\ub2f4\ub2f9\uc790_\ubaa9\ub85d(requirementAggrDTO));
    }

    @GetMapping(value={"/reqStatus/reqIssues-created-together"})
    public ResponseEntity<List<AlmIssueEntity>> \uc694\uad6c\uc0ac\ud56d_\ubb36\uc74c_\uc870\ud68c(@RequestParam(value="pdServiceId") Long pdServiceLink, @RequestParam(value="pdServiceVersions") List<Long> pdServiceVersionLinks, @RequestParam(value="cReqLink") Long \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514) {
        return ResponseEntity.ok(this.requirementService.\ud568\uaed8_\uc0dd\uc131\ub41c_\uc694\uad6c\uc0ac\ud56d_\uc774\uc288\ubaa9\ub85d(pdServiceLink, pdServiceVersionLinks, \uc694\uad6c\uc0ac\ud56d_\uc544\uc774\ub514));
    }

    @GetMapping(value={"/reqStatus/deletedIssueList"})
    public ResponseEntity<List<AlmIssueEntity>> deletedIssueList(@RequestParam(value="pdServiceLink") Long pdServiceLink, @RequestParam(value="pdServiceVersionLinks") List<Long> pdServiceVersionLinks) {
        return ResponseEntity.ok(this.requirementService.deletedIssueList(pdServiceLink, pdServiceVersionLinks));
    }

    @PutMapping(value={"/reqStatus/deleteWithdrawal"})
    public ResponseEntity<?> \uc774\uc288_\uc0ad\uc81c\ucca0\ud68c(@RequestBody List<AlmIssueEntity> \uc0ad\uc81c_\ucca0\ud68c\ub300\uc0c1_\ubaa9\ub85d) throws Exception {
        return ResponseEntity.ok((Object)this.requirementService.\uc774\uc288_\uc0ad\uc81c\ucca0\ud68c(\uc0ad\uc81c_\ucca0\ud68c\ub300\uc0c1_\ubaa9\ub85d));
    }

    @PostMapping(value={"/req-gantt/resolution"})
    public ResponseEntity<List<ReqProgressVO>> \uc77c\ubc18_\ubc84\uc804\ud544\ud130_\ud574\uacb0\ucc45\uc720\ubb34_\uac80\uc0c9(@RequestBody RequirementDTO requirementDTO, @RequestParam(required=false) String resolution) {
        log.info("[RequirementController :: \uc77c\ubc18_\ubc84\uc804\ud544\ud130_\ud574\uacb0\ucc45\uc720\ubb34_\uac80\uc0c9]");
        return ResponseEntity.ok(this.requirementService.\uc77c\ubc18_\ubc84\uc804\ud544\ud130_\ud574\uacb0\ucc45\uc720\ubb34_\uac80\uc0c9(requirementDTO, resolution));
    }

    @PostMapping(value={"/reqStatus/issueListByUpdatedDate"})
    public ResponseEntity<List<AlmIssueEntity>> issueListByUpdatedDate(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByUpdatedDate] :: pdServiceId => {}, pdServiceVersions => {}", (Object)requirementDTO.getPdServiceAndIsReq().getIsReq(), (Object)requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());
        return ResponseEntity.ok(this.requirementService.issueListByUpdatedDate(requirementDTO));
    }

    @PostMapping(value={"/reqStatus/issue-list-by-updated-2nd"})
    public ResponseEntity<List<AlmIssueEntity>> issueListByUpdated2ndTab(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByUpdated2ndTab] :: pdServiceId => {}, pdServiceVersions => {}", (Object)requirementDTO.getPdServiceAndIsReq().getIsReq(), (Object)requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());
        return ResponseEntity.ok(this.requirementService.issueListByUpdated2ndTab(requirementDTO));
    }

    @PostMapping(value={"/reqStatus/issue-list-by-updated"})
    public ResponseEntity<List<HierarchicalAlmIssue>> issueListByUpdated(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByUpdated] :: pdServiceId => {}, pdServiceVersions => {}", (Object)requirementDTO.getPdServiceAndIsReq().getIsReq(), (Object)requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());
        return ResponseEntity.ok(this.requirementService.issueListByAdvancedDiscovery(requirementDTO));
    }

    @PostMapping(value={"/reqStatus/subtasks-and-linked-issues"})
    public ResponseEntity<List<HierarchicalAlmIssue>> issueListBySubtasksAndLinkedIssues(@RequestBody SubtaskAndLinkedIssuesRequestDTO requestDTO) {
        log.info("[RequirementController :: issueListBySubtasksAndLinkedIssues] :: subtaskCount : {}, LinkedIssueCount : {}", (Object)requestDTO.getSubtaskCount(), (Object)requestDTO.getLinkedIssueCount());
        return ResponseEntity.ok(this.requirementService.subtasksAndLinkedIssues(requestDTO));
    }

    @PostMapping(value={"/reqStatus/issueListByOverallUpdatedDate"})
    public ResponseEntity<List<AlmIssueEntity>> issueListByOverallUpdatedDate(@RequestBody RequirementDTO requirementDTO) {
        log.info("[RequirementController :: issueListByOverallUpdatedDate] :: pdServiceId => {}, pdServiceVersions => {}", (Object)requirementDTO.getPdServiceAndIsReq().getIsReq(), (Object)requirementDTO.getPdServiceAndIsReq().getPdServiceVersions().toString());
        return ResponseEntity.ok(this.requirementService.issueListByOverallUpdatedDate(requirementDTO));
    }

    @PostMapping(value={"/reqStatus/issue-list-by-pd"})
    public ResponseEntity<List<AlmIssueEntity>> issueListByPd(@RequestBody RequirementDTO requirementDTO) {
        List<AlmIssueEntity> allListByRequirementDTO = this.requirementService.getAllListByRequirementDTO(requirementDTO);
        log.info("allListByRequirementDTO returnList size => {}", (Object)allListByRequirementDTO.size());
        return ResponseEntity.ok(allListByRequirementDTO);
    }
}

