package com.arms.api.admin.almissue.service;


import com.arms.api.admin.esIndex.model.vo.IndexStatusSumVO;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.util.aspect.DwrSendAlarm;
import com.arms.egovframework.javaservice.esframework.annotation.IndexStatusSnapShot;
import com.arms.egovframework.javaservice.esframework.model.vo.CatIndexVO;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
@Slf4j
@AllArgsConstructor
public class AlmIssueIndexAdminServiceImpl implements AlmIssueIndexAdminService {

    private final EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    @Async
    @IndexStatusSnapShot(value = "almIssue merge index job", clazz = AlmIssueEntity.class)
    @DwrSendAlarm(messageOnStart = "AlmIssue Index Merge 시작" , messageOnEnd = "AlmIssue Index Merge 시작")
    @Override
    public void merge() {
        esCommonRepositoryWrapper.mergeWithReindex(0);
    }

    @Async
    @IndexStatusSnapShot(value = "almIssue merge index job",clazz = AlmIssueEntity.class)
    @DwrSendAlarm(messageOnStart = "AlmIssue Index Merge", messageOnEnd = "AlmIssue Index Merge 완료")
    @Override
    public void merge(int day) {
        esCommonRepositoryWrapper.mergeWithReindex(day);
    }

    @Override
    public IndexStatusSumVO almIssueIndexSumList(){
        List<CatIndexVO> catIndexVOList = esCommonRepositoryWrapper.catIndexVOList();
        return IndexStatusSumVO.builder()
                .indexName(esCommonRepositoryWrapper.indexAliasName())
                .indexCount(esCommonRepositoryWrapper.indexAllCount())
                .docsCount(catIndexVOList.stream().mapToLong(CatIndexVO::getDocsCount).sum())
                .docDeleted(catIndexVOList.stream().mapToLong(CatIndexVO::getDocDeleted).sum())
                .build();
    }


}
