package com.arms.api.analysis.resource.model.vo.wordcloud;

import com.arms.api.analysis.resource.model.dto.wordcloud.WordCloudExcelDTO;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class WordCloudExcelVO {

    private String accountId;
    private String name;

    // 담당하고 있는 issueTotal
    private Long issueTotal;
    // 담당하고 있는 reqIssueTotal
    private Long reqIssueTotal;
    // 담당하고 있는 notReqIssueTotal
    private Long notReqIssueTotal;


    public static WordCloudExcelVO fromDTO (WordCloudExcelDTO dto) {
        return WordCloudExcelVO.builder()
                .accountId(dto.getAccountId())
                .name(dto.getName())
                .issueTotal(dto.getIssueTotal())
                .reqIssueTotal(dto.getReqIssueTotal())
                .notReqIssueTotal(dto.getNotReqIssueTotal())
                .build();
    }
}
