package com.arms.api.issue.almapi.service;

import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.msa_communicate.MiddleProxyArmsStateCategory;
import com.arms.api.issue.almapi.model.dto.ArmsStateCategoryDTO;
import com.arms.api.util.response.CommonResponse;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Slf4j
@Component
@AllArgsConstructor
public class CategoryMappingService {

    private final MiddleProxyArmsStateCategory middleProxyMiddleProxyArmsStateCategory;

    public String getMappingCategory(ServerInfo serverInfo,  String statusId) {
        return this.getMappingCategory(serverInfo,null,null,statusId);
    }

    public String getMappingCategory(ServerInfo serverInfo, String projectKey, String issueTypeId, String statusId) {

        if (serverInfo == null || serverInfo.getConnectId() == null) {
            log.error(" [ getMappingCategory ] :: 유효한 값이 없습니다 :: ServerInfo");
            return null;
        }

        if (StringUtils.isEmpty(statusId)) {
            log.error(" [ getMappingCategory ] :: 유효한 값이 없습니다 :: statusId");
            return null;
        }

        String connectId = String.valueOf(serverInfo.getConnectId());

        // ARMS 상태 카테고리 매핑 정보 조회
        return getCategoryName(connectId, projectKey, issueTypeId, statusId);
    }

    private String getCategoryName(String connectId, String projectKey, String issueTypeId, String statusId) {
        CommonResponse.ApiResult<ArmsStateCategoryDTO> armsStateCategory = middleProxyMiddleProxyArmsStateCategory.getArmsStateCategory(connectId, projectKey, issueTypeId, statusId);
        ArmsStateCategoryDTO armsStateCategoryDTO = armsStateCategory.getResponse();

        if (armsStateCategoryDTO == null || StringUtils.isEmpty(armsStateCategoryDTO.getId())) {
            log.warn("[getCategoryName] :: 카테고리 매핑 없음 - connectId={}, projectKey={}, issueTypeId={}, statusId={}", connectId, projectKey, issueTypeId, statusId);
            return null;
        }

        return armsStateCategoryDTO.getName();
    }
}