package com.arms.api.issue.almapi.service;

import com.arms.api.issue.almapi.model.dto.AlmIssueIncrementDTO;
import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import com.arms.api.issue.almapi.model.dto.CReqProperty;
import com.arms.api.issue.almapi.model.entity.AlmIssueEntity;
import com.arms.api.issue.almapi.model.vo.cloudjiraspec.CloudJiraIssueRawDataVO;
import com.arms.api.serverinfo.model.ServerInfo;
import com.arms.api.serverinfo.service.ServerInfoService;
import com.arms.api.util.alm.JiraApi;
import com.arms.api.util.alm.JiraUtil;
import com.arms.egovframework.javaservice.esframework.config.EsIndexTemplateConfig;
import com.arms.egovframework.javaservice.esframework.model.vo.DocumentResultWrapper;
import com.arms.egovframework.javaservice.esframework.repository.common.EsCommonRepositoryWrapper;
import com.arms.egovframework.javaservice.esframework.esquery.SimpleQuery;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.bean.override.mockito.MockitoBean;
import org.springframework.web.reactive.function.client.WebClient;

import java.util.*;
import java.util.function.Function;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;

@SpringBootTest(properties = {
        "spring.profiles.active=dev",
        "arms-index-name.jiraissue=test_jiraissue",
        "arms-index-name.serverinfo=serverinfo"
})
@TestMethodOrder(MethodOrderer.OrderAnnotation.class)
public class ARMSCloudJiraARMSTEST_43PdServiceIdsTest {

    @Autowired
    IssueService issueService;

    @Autowired
    ServerInfoService serverInfoService;

    @MockitoBean
    CategoryMappingService categoryMappingService;

    @Autowired
    EsCommonRepositoryWrapper<AlmIssueEntity> esCommonRepositoryWrapper;

    @Autowired
    EsIndexTemplateConfig esIndexTemplateConfig;

    @Autowired
    JiraUtil jiraUtil;

    @Autowired
    JiraApi jiraApi;

    @BeforeEach
    void 요구사항키_셋업() {
        esCommonRepositoryWrapper.deleteIndexWithDayRange(-1);
        esCommonRepositoryWrapper.saveEmpty(new AlmIssueEntity());
        when(categoryMappingService.getMappingCategory(any(),any(),any(),any()))
                .thenReturn("");
        AlmIssueWithRequirementDTO almIssueWithRequirementDTO = new AlmIssueWithRequirementDTO();
        almIssueWithRequirementDTO.setJiraServerId("936493109998294575");
        almIssueWithRequirementDTO.setIssueKey("ARMSTEST-72");
        almIssueWithRequirementDTO.setServiceId(72L);
        almIssueWithRequirementDTO.setVersions(List.of(72L));
        almIssueWithRequirementDTO.setProjectKeyOrId("ARMSTEST");
        almIssueWithRequirementDTO.setCReqLink(72L);

        CReqProperty cReqProperty = new CReqProperty();
        cReqProperty.setCReqPriorityLink(1L);
        almIssueWithRequirementDTO.setCReqProperty(cReqProperty);

        issueService.preSaveReqStatus(almIssueWithRequirementDTO);

        AlmIssueWithRequirementDTO almIssueWithRequirementDTO2 = new AlmIssueWithRequirementDTO();
        almIssueWithRequirementDTO2.setJiraServerId("936493109998294575");
        almIssueWithRequirementDTO2.setIssueKey("ARMSTEST-43");
        almIssueWithRequirementDTO2.setServiceId(43L);
        almIssueWithRequirementDTO2.setVersions(List.of(43L));
        almIssueWithRequirementDTO2.setProjectKeyOrId("ARMSTEST");
        almIssueWithRequirementDTO2.setCReqLink(43L);

        CReqProperty cReqProperty2 = new CReqProperty();
        cReqProperty2.setCReqPriorityLink(1L);
        almIssueWithRequirementDTO2.setCReqProperty(cReqProperty2);

        issueService.preSaveReqStatus(almIssueWithRequirementDTO2);

    }

    @Test
    public void 암스_클라우드_지라_증분_테스트_2025_01_01_2025_07_27() {

        List<String> values = Arrays.asList("ARMSTEST");
        Collections.shuffle(values);

        for (String value : values) {
            AlmIssueIncrementDTO almIssueIncrementDTO = AlmIssueIncrementDTO.builder()
                    .serverId("936493109998294575")
                    .projectKey(value)
                    .startDate("2025-09-18")
                    .endDate("2025-09-19")
                    .build();
            List<AlmIssueEntity> almIssueEntities = issueService.discoveryIncrementALmIssueAndGetReqAlmIssueEntities(almIssueIncrementDTO);
        }

//        암스_클라우드지라_데이터_검증();
    }

    @Test
    public void 암스_클라우드_지라_요구사항_별_테스트() throws Exception {

//
//        AlmIssueWithRequirementDTO almIssueWithRequirementDTO = new AlmIssueWithRequirementDTO();
//        almIssueWithRequirementDTO.setJiraServerId("936493109998294575");
//        almIssueWithRequirementDTO.setIssueKey("ARMSTEST-72");
//        almIssueWithRequirementDTO.setServiceId(72L);
//        almIssueWithRequirementDTO.setVersions(List.of(72L));
//        almIssueWithRequirementDTO.setProjectKeyOrId("ARMSTEST");
//        almIssueWithRequirementDTO.setCReqLink(72L);
//
//        CReqProperty cReqProperty = new CReqProperty();
//        cReqProperty.setCReqPriorityLink(1L);
//        almIssueWithRequirementDTO.setCReqProperty(cReqProperty);
//
//        issueService.discoveryALmIssueAndGetReqAlmIssueEntity(almIssueWithRequirementDTO);
//
//        AlmIssueWithRequirementDTO almIssueWithRequirementDTO2 = new AlmIssueWithRequirementDTO();
//        almIssueWithRequirementDTO2.setJiraServerId("936493109998294575");
//        almIssueWithRequirementDTO2.setIssueKey("ARMSTEST-43");
//        almIssueWithRequirementDTO2.setServiceId(43L);
//        almIssueWithRequirementDTO2.setVersions(List.of(43L));
//        almIssueWithRequirementDTO2.setProjectKeyOrId("ARMSTEST");
//        almIssueWithRequirementDTO2.setCReqLink(43L);
//
//        CReqProperty cReqProperty2 = new CReqProperty();
//        cReqProperty2.setCReqPriorityLink(1L);
//        almIssueWithRequirementDTO2.setCReqProperty(cReqProperty2);
//
//        issueService.discoveryALmIssueAndGetReqAlmIssueEntity(almIssueWithRequirementDTO2);


    }


    public void 암스_클라우드지라_데이터_검증(){

        DocumentResultWrapper<AlmIssueEntity> findRecentHits
            = esCommonRepositoryWrapper.findRecentHits(SimpleQuery.termQueryFilter("jira_server_id", "1000000000000000004"));

        List<AlmIssueEntity> docs = findRecentHits.toDocs();

        ServerInfo serverInfo = serverInfoService.verifyServerInfo("1000000000000000004");

        WebClient webClient = jiraUtil.createJiraCloudCommunicator(serverInfo.getUri(), serverInfo.getUserId(), serverInfoService.getDecryptPasswordOrToken(serverInfo));

        Function<String,LinkedListVO> retrieveAlmF = (str)->this.issueList(webClient,jiraApi.getEndpoint().getIssue().getBase() + "/" + str + "?" + jiraApi.getParameter().getFields());

        new EsDataValidationTest(esCommonRepositoryWrapper,retrieveAlmF).dataValid(docs);

    }


    private LinkedListVO issueList( WebClient webClient, String endpoint) {
        Set<String> linkedIssueSet = new HashSet<>();
        CloudJiraIssueRawDataVO block = jiraUtil.getWithRawData(webClient, endpoint, CloudJiraIssueRawDataVO.class);
        Objects.requireNonNull(block)
            .getFields().getIssuelinks().stream().filter(Objects::nonNull)
                .forEach(a -> {
                    if(a.getInwardIssue()!=null){
                        linkedIssueSet.add(a.getInwardIssue().getKey());
                    }

                    if(a.getOutwardIssue()!=null){
                        linkedIssueSet.add(a.getOutwardIssue().getKey());
                    }
                });

        return new LinkedListVO(
                 Objects.requireNonNull(block).getFields().getProject().getKey()
                ,Objects.requireNonNull(block).getKey()
                ,linkedIssueSet.stream().toList()
        );
    }


}
