package com.arms.api.admin.esIndex.controller;

import com.arms.api.admin.esIndex.model.vo.IndexStatusSumVO;
import com.arms.api.admin.esIndex.service.ElasticSearchIndexAdminService;
import com.arms.api.util.response.CommonResponse;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

import static com.arms.api.util.response.CommonResponse.success;


@RequestMapping("/engine/index/es-index")
@AllArgsConstructor
@RestController
public class ElasticSearchIndexAdminController {

    private final ElasticSearchIndexAdminService elasticSearchIndexAdminService;

    @GetMapping("/sum-list")
    public ResponseEntity<CommonResponse.ApiResult<List<IndexStatusSumVO>>> esIndexSumList()  {
        return ResponseEntity.ok(success(elasticSearchIndexAdminService.esIndexSumList()));
    }
}
