package com.arms.api.search_engine.controller;

import com.arms.api.fluentd.model.vo.ScheduleHistoryVO;
import com.arms.api.fluentd.service.FluentdSearch;
import com.arms.api.search_engine.dto.BaseSearchAggrDTO;
import com.arms.api.search_engine.dto.SearchDTO;
import com.arms.api.search_engine.service.AlmIssueSearch;
import com.arms.api.search_engine.vo.SearchAggrResultVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@RestController
@RequestMapping("/engine/search")
@Slf4j
public class SearchController {

    @Autowired
    private AlmIssueSearch almIssueSearch;

    @Autowired
    private FluentdSearch fluentdSearch;

    @PostMapping("/almIssue")
    public ResponseEntity<?> searchAlmIssue(@RequestBody SearchDTO searchDTO) {
        log.info("[SearchController :: AlmIssueSearch] :: searchString => {}" , searchDTO.getSearchString());

        return ResponseEntity.ok(almIssueSearch.searchAlmIssue(searchDTO));
    }

    @PostMapping("/log")
    public ResponseEntity<?> searchFluentdLog(@RequestBody SearchDTO searchDTO) {
        log.info("[SearchController :: searchFluentdLog] :: searchString => {}" , searchDTO.getSearchString());

        return ResponseEntity.ok(fluentdSearch.searchFluentdLog(searchDTO));
    }

    @PostMapping("/almIssue/project-aggr-top5")
    public ResponseEntity<SearchAggrResultVO> findAlmIssueAggregationDataByAlmProjectName(@RequestBody BaseSearchAggrDTO searchAggrDTO) {
        log.info("[SearchController :: findAlmIssueAggregationDataByAlmProjectName]");

        return ResponseEntity.ok(almIssueSearch.aggregateByAlmProjectName(searchAggrDTO));
    }

    @PostMapping("/log/aggr-top5")
    public ResponseEntity<SearchAggrResultVO> findFluentdLogAggregationDataByLogName(@RequestBody BaseSearchAggrDTO searchAggrDTO) {
        log.info("[SearchController :: findFluentdLogAggregationDataByLogName]");

        return ResponseEntity.ok(fluentdSearch.aggregateByFluentdLogName(searchAggrDTO));
    }

    @PostMapping("/schedule-history-log")
    public ResponseEntity<List<ScheduleHistoryVO>> getScheduleHistory(@RequestBody SearchDTO searchDTO) {
        log.info("[SearchController :: getScheduleHistory]");

        return ResponseEntity.ok(fluentdSearch.getScheduleHistory(searchDTO));
    }


}
