package com.arms.api.admin.fluentd.controller;

import com.arms.api.admin.fluentd.service.FluentdIndexAdminService;
import com.arms.api.util.response.CommonResponse;
import lombok.AllArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.arms.api.util.response.CommonResponse.success;


@RequestMapping("/engine/index/fluentd")
@AllArgsConstructor
@RestController
public class FluentdAdminController {

    private final FluentdIndexAdminService fluentdIndexAdminService;

    @PostMapping("/delete")
    public ResponseEntity<CommonResponse.ApiResult<String>> indexDelete()  {
        fluentdIndexAdminService.delete();
        return ResponseEntity.ok(success("OK"));
    }

    @PostMapping("/delete/day/{day}")
    public ResponseEntity<CommonResponse.ApiResult<String>> indexDelete(@PathVariable int day)  {
        fluentdIndexAdminService.delete(day);
        return ResponseEntity.ok(success("OK"));
    }

    @PostMapping("/merge-with-reindex")
    public ResponseEntity<CommonResponse.ApiResult<String>> mergeWithReindex()  {
        fluentdIndexAdminService.merge();
        return ResponseEntity.ok(success("OK"));
    }

    @PostMapping("/merge-with-reindex/day/{day}")
    public ResponseEntity<CommonResponse.ApiResult<String>> mergeWithReindex(@PathVariable int day)  {
        fluentdIndexAdminService.merge(day);
        return ResponseEntity.ok(success("OK"));
    }


}
