package com.arms.api.analysis.scope.controller;


import com.arms.api.analysis.scope.dto.ScopeDTO;
import com.arms.api.analysis.scope.service.AnalysisScope;
import com.arms.api.analysis.scope.vo.*;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.util.List;
import java.util.Optional;

@RestController
@RequestMapping("/engine/analysis-scope")
@Slf4j
@AllArgsConstructor
public class AnalysisScopeController {

    private final AnalysisScope analysisScope;

    // circular-packing-data
    @PostMapping("/circular-packing-data")
    public ResponseEntity<List<CircularPackingChartVO>> getCircularPackingChartDataV2(@RequestBody ScopeDTO scopeDTO) {

        return ResponseEntity.ok(analysisScope.getCircularPackingChartDataV2(scopeDTO));

    }

    // 트리바 데이터 (topN 이 없을 경우 전체, 존재 -> topN 적용)
    @PostMapping("/tree-bar-data")
    public ResponseEntity<List<TreeBarIssueVO>> treeBarData(@RequestBody ScopeDTO scopeDTO) {

        log.info("[AnalysisScopeController :: treeBarData] :: topN = {}", Optional.ofNullable(scopeDTO.getTopN()).orElse(-1));

        return ResponseEntity.ok(analysisScope.treeBarData(scopeDTO));

    }

    @PostMapping("/tree-bar-data-v2")
    public ResponseEntity<List<TreeBarIssueVO>> treeBarDataV2(@RequestBody ScopeDTO scopeDTO) {

        log.info("[AnalysisScopeController :: treeBarDataV2] :: topN = {}", Optional.ofNullable(scopeDTO.getTopN()).orElse(-1));

        return ResponseEntity.ok(analysisScope.treeBarDataV2(scopeDTO));

    }

    // 네트워크 차트
    @PostMapping("/getPdServiceVersionsAndReq")
    public List<PdServiceVersionsAndReqVO> getPdServiceVersionsAndReq(@RequestBody ScopeDTO scopeDto) throws IOException {

        log.info("AnalysisScopeController :: getPdServiceVersionsAndReq");

        List<PdServiceVersionsAndReqVO> pdServiceVersionsAndReq = analysisScope.getPdServiceVersionsAndReq(scopeDto);
        return pdServiceVersionsAndReq;
    }

    @PostMapping("/getVersionsAndIssueList")
    public List<IssueVO> getVersionsAndIssuList(@RequestBody ScopeDTO scopeDto) {

        log.info("AnalysisScopeController :: getVersionsAndIssuList");

        List<IssueVO> issues = analysisScope.getVersionsAndIssuList(scopeDto);

        return issues;
    }

    @PostMapping("/getIssueList")
    public List<IssueVO> getIssueList(@RequestBody ScopeDTO scopeDto) {

        log.info("AnalysisScopeController :: getIssues");

        List<IssueVO> issues = analysisScope.getIssueList(scopeDto);

        return issues;
    }

    @PostMapping("/getNetworkChartExcelData")
    public List<NetworkChartExcelDataVO> getNetworkChartExcelData(@RequestBody ScopeDTO scopeDto) {

        log.info("AnalysisScopeController :: getNetworkChartExcelData");

        return analysisScope.getNetworkChartExcelData(scopeDto);
    }

    @PostMapping("/getDataTableIssues")
    public List<ReqDataTableIssuesVO> getDataTableIssues(@RequestBody ScopeDTO scopeDto) {

        log.info("AnalysisScopeController :: getDataTableIssues");

        return analysisScope.getDataTableIssues(scopeDto);
    }
}
