package com.arms.api.dashboard.model.vo;

import com.arms.api.util.ParseUtil;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class TopNReqAssigneeVO {

    private String accountId;
    private String name;
    private String emailAddress;
    private String nameWithEmailId;
    private Long reqCount;
//    private Long notReqCount;
//    private Long totalCount;

    public void setNameWithUserName(String name, String emailAddress){
        if (emailAddress == null) {
            this.nameWithEmailId = name;
        } else {
            this.nameWithEmailId = name + "("+ParseUtil.extractUsernameFromEmail(emailAddress)+")";
            ParseUtil.extractUsernameFromEmail(emailAddress);
        }
    }

    public void addReqCount(Long reqCount) {
        this.reqCount += reqCount;
    }
}
