package com.arms.api.issue.almapi.model.vo;

import com.arms.api.issue.almapi.model.dto.AlmIssueWithRequirementDTO;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.Map;

import static java.util.stream.Collectors.*;


@Getter
@Slf4j
public class CloudJiraIssueVOCollection {

    private final List<CloudJiraIssueVO> cloudJiraIssueVOS;

    public CloudJiraIssueVOCollection(List<CloudJiraIssueVO> cloudJiraIssueVOS){
        this.cloudJiraIssueVOS = cloudJiraIssueVOS;
    }

    public List<CloudJiraIssueVO> appliedLinkedIssuePdServiceVO() {

        Map<CloudJiraIssueVO, List<AlmIssueWithRequirementDTO>> cloudJiraIssueVOListMap
            = cloudJiraIssueVOS
                .stream()
                .collect(groupingBy(vo -> vo, mapping(CloudJiraIssueVO::getAlmIssueWithRequirementDTO, toList())));

        return cloudJiraIssueVOListMap
                .entrySet()
                .stream()
                .map(a-> a.getKey().appliedLinkedIssuePdServiceElement(a.getValue()))
                .toList();

    }

}
