package com.arms.api.issue.type.controller;

import com.arms.api.issue.type.vo.IssueTypeVO;
import com.arms.api.issue.type.service.IssueTypeService;
import com.arms.api.util.errors.ErrorCode;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/{connectId}/jira/issuetype")
@AllArgsConstructor
public class IssueTypeController {

    private final IssueTypeService issueTypeService;

    @ResponseBody
    @RequestMapping(
            value = {"/list"},
            method = {RequestMethod.GET}
    )
    public List<IssueTypeVO> getIssueTypeList(@PathVariable("connectId") String connectId) {

        if (connectId == null) {
            log.error("getIssueTypeList Error: connectId {}", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("getIssueTypeList Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        return issueTypeService.getIssueTypeList(connectId);
    }

    @ResponseBody
    @RequestMapping(
            value = {"/project/{projectId}"},
            method = {RequestMethod.GET}
    )
    public List<IssueTypeVO> getIssueTypeListByProject(@PathVariable("connectId") String connectId,
                                                       @PathVariable("projectId") String projectId) {

        if (connectId == null) {
            log.error("getIssueTypeListByProject Error: connectId {}", ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
            throw new IllegalArgumentException("getIssueTypeListByProject Error: connectId " + ErrorCode.PARAMETER_SERVER_ID_MISSING.getErrorMsg());
        }

        if (StringUtils.isEmpty(projectId)) {
            log.error("getIssueTypeListByProject Error projectId {}", ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg());
            throw new IllegalArgumentException("getIssueTypeListByProject Error projectId " + ErrorCode.PARAMETER_NULL_ERROR.getErrorMsg());
        }

        return issueTypeService.getIssueTypeListByProject(connectId, projectId);
    }
}
