package com.arms.api.poc.model.entity;

import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchCreatedDate;
import com.arms.egovframework.javaservice.esframework.annotation.ElasticSearchUpdateDate;
import com.arms.egovframework.javaservice.esframework.model.entity.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.Setting;

import java.util.Date;

@Builder
@AllArgsConstructor
@Getter
@Setter
@Document(indexName = "arms_poc")
@Setting(settingPath = "/es-settings/poc-index-settings.json")
public class PocEntity implements BaseEntity {

    @Id
    private String id;

    @Field(type = FieldType.Keyword, name = "c_poc_first_name")
    private String c_poc_first_name;

    @Field(type = FieldType.Keyword, name = "c_poc_last_name")
    private String c_poc_last_name;

    @Field(type = FieldType.Text, name = "c_poc_full_name")
    private String c_poc_full_name;

    @Field(type = FieldType.Text, name = "c_poc_company_name")
    private String c_poc_company_name;

    @Field(type = FieldType.Keyword, name = "c_poc_company_size")
    private String c_poc_company_size;

    @Field(type = FieldType.Keyword, name = "c_poc_job_title")
    private String c_poc_job_title;

    @Field(type = FieldType.Keyword, name = "c_poc_email_address")
    private String c_poc_email_address;

    @Field(type = FieldType.Keyword, name = "c_poc_country")
    private String c_poc_country;

    @Field(type = FieldType.Long, name = "c_poc_country_code")
    private Long c_poc_country_code;

    @Field(type = FieldType.Keyword, name = "c_poc_contact_number")
    private String c_poc_contact_number;

    @Field(type = FieldType.Keyword, name = "c_poc_inquiry_reason")
    private String c_poc_inquiry_reason;

    @Field(type = FieldType.Text, name = "c_poc_inquiry_content")
    private String c_poc_inquiry_content;

    @Field(type = FieldType.Date, name = "c_poc_inquiry_date")
    private Date c_poc_inquiry_date;

    @Field(type = FieldType.Keyword, name = "c_poc_assignee_id")
    private String c_poc_assignee_id;

    @Field(type = FieldType.Keyword, name = "c_poc_assignee_username")
    private String c_poc_assignee_username;

    @Field(type = FieldType.Keyword, name = "c_poc_assignee_name")
    private String c_poc_assignee_name;

    @Field(type = FieldType.Keyword, name = "c_poc_assignee_email")
    private String c_poc_assignee_email;

    @Field(type = FieldType.Long, name = "c_poc_assignee_link")
    private Long c_poc_assignee_link;

    @Field(type = FieldType.Keyword, name = "c_poc_status")
    @Builder.Default
    private String c_poc_status = "PENDING";

    @Field(type = FieldType.Text, name = "c_poc_status_memo")
    private String c_poc_status_memo;

    @Field(type = FieldType.Date, name = "c_poc_status_updated")
    private Date c_poc_status_updated;

    @Field(type = FieldType.Boolean, name = "c_poc_marketing_consent")
    private Boolean c_poc_marketing_consent;

    @Field(type = FieldType.Keyword, name = "c_poc_etc")
    private String c_poc_etc;

    @Field(type = FieldType.Text, name = "c_poc_desc")
    private String c_poc_desc;

    @Field(type = FieldType.Text, name = "c_poc_contents")
    private String c_poc_contents;

    @Field(type = FieldType.Date, name = "created_date")
    @ElasticSearchCreatedDate
    @Setter
    private Date createdDate;

    @Field(type = FieldType.Date, name = "updated_date")
    @ElasticSearchUpdateDate
    @Setter
    private Date updatedDate;

    public void updatePocEntity(PocEntity pocEntity) {

        if (pocEntity.c_poc_first_name != null) {
            this.c_poc_first_name = pocEntity.c_poc_first_name;
        }

        if (pocEntity.c_poc_last_name != null) {
            this.c_poc_last_name = pocEntity.c_poc_last_name;
        }

        if (pocEntity.c_poc_full_name != null) {
            this.c_poc_full_name = pocEntity.c_poc_full_name;
        }

        if (pocEntity.c_poc_company_name != null) {
            this.c_poc_company_name = pocEntity.c_poc_company_name;
        }

        if (pocEntity.c_poc_company_size != null) {
            this.c_poc_company_size = pocEntity.c_poc_company_size;
        }

        if (pocEntity.c_poc_job_title != null) {
            this.c_poc_job_title = pocEntity.c_poc_job_title;
        }

        if (pocEntity.c_poc_email_address != null) {
            this.c_poc_email_address = pocEntity.c_poc_email_address;
        }

        if (pocEntity.c_poc_country != null) {
            this.c_poc_country = pocEntity.c_poc_country;
        }

        if (pocEntity.c_poc_country_code != null) {
            this.c_poc_country_code = pocEntity.c_poc_country_code;
        }

        if (pocEntity.c_poc_contact_number != null) {
            this.c_poc_contact_number = pocEntity.c_poc_contact_number;
        }

        if (pocEntity.c_poc_inquiry_reason != null) {
            this.c_poc_inquiry_reason = pocEntity.c_poc_inquiry_reason;
        }

        if (pocEntity.c_poc_inquiry_content != null) {
            this.c_poc_inquiry_content = pocEntity.c_poc_inquiry_content;
        }

        if (pocEntity.c_poc_assignee_id != null) {
            this.c_poc_assignee_id = pocEntity.c_poc_assignee_id;
        }

        if (pocEntity.c_poc_assignee_username != null) {
            this.c_poc_assignee_username = pocEntity.c_poc_assignee_username;
        }

        if (pocEntity.c_poc_assignee_name != null) {
            this.c_poc_assignee_name = pocEntity.c_poc_assignee_name;
        }

        if (pocEntity.c_poc_assignee_email != null) {
            this.c_poc_assignee_email = pocEntity.c_poc_assignee_email;
        }

        if (pocEntity.c_poc_assignee_link != null) {
            this.c_poc_assignee_link = pocEntity.c_poc_assignee_link;
        }

        if (pocEntity.c_poc_status != null) {
            this.c_poc_status = pocEntity.c_poc_status;
        }

        if (pocEntity.c_poc_status_memo != null) {
            this.c_poc_status_memo = pocEntity.c_poc_status_memo;
        }

        if (pocEntity.c_poc_status_updated != null) {
            this.c_poc_status_updated = pocEntity.c_poc_status_updated;
        }

        if (pocEntity.c_poc_marketing_consent != null) {
            this.c_poc_marketing_consent = pocEntity.c_poc_marketing_consent;
        }

        if (pocEntity.c_poc_etc != null) {
            this.c_poc_etc = pocEntity.c_poc_etc;
        }

        if (pocEntity.c_poc_desc != null) {
            this.c_poc_desc = pocEntity.c_poc_desc;
        }

        if (pocEntity.c_poc_contents != null) {
            this.c_poc_contents = pocEntity.c_poc_contents;
        }
    }

    private PocEntity() {}
}
