package com.arms.api.issue.almapi.service;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.common.SingleRootFileSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.TestInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ResourceLoader;

import java.io.File;
import java.io.IOException;

import static com.github.tomakehurst.wiremock.core.WireMockConfiguration.wireMockConfig;

@TestInstance(TestInstance.Lifecycle.PER_CLASS)
public abstract class WireMockRedmineConfig {

    protected static WireMockServer mockServer1;

    @Autowired
    private ResourceLoader resourceLoader;

    @BeforeAll
    public void startWireMocks() throws IOException {

/*        File mappingFile =  new File("src/test/resources/wiremock/redmine/mappings").getAbsoluteFile();
        File file =  new File("src/test/resources/wiremock/redmine/__files").getAbsoluteFile();


        if (!mappingFile.exists()) {
            mappingFile.mkdirs();
        }

        if (!file.exists()) {
            file.mkdirs();
        }*/


        mockServer1 = new WireMockServer(
                wireMockConfig()
                        .port(8089)
                        .usingFilesUnderClasspath("wiremock/redmine")
        );

//        mockServer1.enableRecordMappings(new SingleRootFileSource(mappingFile),new SingleRootFileSource(file));

        mockServer1.start();

//        mockServer1.startRecording("http://313.co.kr:3333");


    }

    @AfterAll
    public void stopWireMocks() {
        if (mockServer1 != null && mockServer1.isRunning()) {
//            mockServer1.stopRecording();
            mockServer1.stop();
        }
    }
}
