/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.schedule.service;

import com.arms.api.schedule.model.dto.ScheduleInfoDTO;
import com.arms.api.schedule.model.vo.ScheduleDetailVO;
import com.arms.api.schedule.model.vo.ScheduleHistoryVO;
import com.arms.api.schedule.model.vo.ScheduleInfoVO;
import com.arms.api.schedule.model.vo.ScheduleMapVO;
import com.arms.api.schedule.service.ScheduleService;
import com.arms.api.schedule.util.ScheduleFileReader;
import com.arms.api.schedule.util.ScheduleMapProvider;
import com.arms.api.schedule.util.ScheduleTaskDispatcher;
import com.arms.api.systeminfo.model.SystemInfoVO;
import com.arms.api.systeminfo.service.SystemInfo;
import com.arms.api.util.GiteaFileUtil;
import com.arms.api.util.external_communicate.BackendCoreCommunicator;
import com.arms.api.util.external_communicate.EngineCommunicator;
import com.arms.api.util.external_communicate.dto.SearchDTO;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="scheduleService")
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    private final ScheduleMapProvider mapProvider;
    private final ScheduleTaskDispatcher dispatcher;
    @Value(value="${spring.cloud.config.server.git.username}")
    private String gitUsername;
    @Value(value="${spring.cloud.config.server.git.password}")
    private String gitPassword;
    @Value(value="${spring.cloud.config.server.git.default-label}")
    private String gitBranch;
    @Value(value="${gitea.schedule-config}")
    private String scheduleDirectoryUrl;
    private final EngineCommunicator engineCommunicator;
    private final BackendCoreCommunicator backendCoreCommunicator;
    private final SystemInfo systemInfo;

    public void almIssueMergeWithReindex() {
        try {
            SystemInfoVO systemInfoVO = this.systemInfo.getSystemInfo(Long.valueOf(0L));
            if (systemInfoVO == null || !systemInfoVO.isExistLicenseNumber()) {
                throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
            }
            this.engineCommunicator.almIssueMergeWithReindex();
        }
        catch (Exception e) {
            throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
        }
    }

    public void fluentdMergeWithReindex() {
        try {
            SystemInfoVO systemInfoVO = this.systemInfo.getSystemInfo(Long.valueOf(0L));
            if (systemInfoVO == null || !systemInfoVO.isExistLicenseNumber()) {
                throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
            }
            this.engineCommunicator.fluentdMergeWithReindex();
        }
        catch (Exception e) {
            throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
        }
    }

    public void almIssueMergeWithReindex(int day) {
        try {
            SystemInfoVO systemInfoVO = this.systemInfo.getSystemInfo(Long.valueOf(0L));
            if (systemInfoVO == null || !systemInfoVO.isExistLicenseNumber()) {
                throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
            }
            this.engineCommunicator.almIssueMergeWithReindex(day);
        }
        catch (Exception e) {
            throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
        }
    }

    public void fluentdMergeWithReindex(int day) {
        try {
            SystemInfoVO systemInfoVO = this.systemInfo.getSystemInfo(Long.valueOf(0L));
            if (systemInfoVO == null || !systemInfoVO.isExistLicenseNumber()) {
                throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
            }
            this.engineCommunicator.fluentdMergeWithReindex(day);
        }
        catch (Exception e) {
            throw new IllegalStateException("\ub77c\uc774\uc13c\uc2a4 \uc815\ubcf4 \uac00\uc838\uc624\uae30 \uc2e4\ud328.");
        }
    }

    public void serverInfoBackup() {
        this.engineCommunicator.serverInfoBackup();
    }

    public void executeIncrementalIssueWithDateRangeSequentialSchedules(String startDate, String endDate) {
        this.backendCoreCommunicator.executeIncrementalIssueWithDateRangeSequentialSchedules(startDate, endDate);
    }

    public void executeSequentialSchedules() {
        this.backendCoreCommunicator.executeSequentialSchedules();
    }

    public void updateReqStatusFromElasticsearch() {
        this.backendCoreCommunicator.updateReqStatusFromElasticsearch();
    }

    public ScheduleMapVO getScheduleList() throws Exception {
        ScheduleMapVO scheduleMapVO = new ScheduleMapVO();
        List ymlFileFullLinks = GiteaFileUtil.getYamlFilesFromDirectory((String)this.scheduleDirectoryUrl, (String)this.gitBranch, (String)this.gitUsername, (String)this.gitPassword);
        if (ymlFileFullLinks.isEmpty()) {
            log.info("[ ScheduleServiceImpl :: getScheduleList ] :: ymlFileFullLinks is empty");
            return new ScheduleMapVO();
        }
        for (String ymlFileFullLink : ymlFileFullLinks) {
            log.info("[ ScheduleServiceImpl :: getScheduleList ] :: ymlFileFullLink => {}", (Object)ymlFileFullLink);
            String ymlFileName = GiteaFileUtil.extractFileNameWithoutExtension((String)ymlFileFullLink);
            List scheduleInfoVOS = ScheduleFileReader.readScheduleYmlFileAndParseToVO((String)ymlFileFullLink, (String)this.gitUsername, (String)this.gitPassword);
            scheduleMapVO.getScheduleInfoMap().put(ymlFileName, scheduleInfoVOS);
        }
        return scheduleMapVO;
    }

    public List<ScheduleDetailVO> getCurrentScheduleList() {
        ArrayList<ScheduleDetailVO> result = new ArrayList<ScheduleDetailVO>();
        ScheduleMapVO scheduleMapVO = this.mapProvider.getScheduleMapVO();
        if (scheduleMapVO == null) {
            log.warn("[ ScheduleService :: getCurrentScheduleList ] :: scheduleMapVO is null");
            return Collections.emptyList();
        }
        if (scheduleMapVO.getScheduleInfoMap() == null) {
            log.warn("[ ScheduleService :: getCurrentScheduleList ] :: scheduleMapVO.getScheduleMap() is null");
            return Collections.emptyList();
        }
        Map scheduleMap = scheduleMapVO.getScheduleInfoMap();
        scheduleMap.forEach((fileName, list) -> {
            for (ScheduleInfoVO vo : list) {
                result.add(ScheduleDetailVO.builder().fileName(fileName).name(vo.getName()).cron(vo.getCron()).notes(vo.getNotes()).enabled(Boolean.TRUE.equals(vo.getEnabled())).build());
            }
        });
        return result;
    }

    public String saveScheduleList(String fileName, List<ScheduleInfoDTO> scheduleList) throws Exception {
        String fileNameWithExt = fileName + ".yml";
        URL url = new URL(this.scheduleDirectoryUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        String auth = this.gitUsername + ":" + this.gitPassword;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                ObjectMapper mapper = new ObjectMapper();
                JsonNode filesArray = mapper.readTree(response.toString());
                boolean fileExists = false;
                String fileSha = null;
                for (JsonNode file : filesArray) {
                    String name = file.get("name").asText();
                    if (!fileNameWithExt.equals(name)) continue;
                    fileExists = true;
                    fileSha = file.get("sha").asText();
                    break;
                }
                String contents = ScheduleFileReader.convertScheduleListToYaml(scheduleList);
                if (fileExists) {
                    log.info("File exists. Updating {}", (Object)fileNameWithExt);
                    int resultOfUpdate = this.updateFileInRepository(this.scheduleDirectoryUrl, fileNameWithExt, fileSha, this.gitBranch, contents);
                    String string = String.valueOf(resultOfUpdate);
                    return string;
                }
                log.error("File {} does not exists.", (Object)fileNameWithExt);
                String string = "File does not exists.";
                return string;
            }
        }
        log.error("Failed to retrieve directory. ResponseCode: {}", (Object)responseCode);
        return String.valueOf(responseCode);
    }

    private int updateFileInRepository(String apiUrl, String fileNameWithExt, String fileSha, String branch, String contents) throws Exception {
        URL url = new URL(apiUrl + fileNameWithExt);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setDoOutput(true);
        String auth = this.gitUsername + ":" + this.gitPassword;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        connection.setRequestProperty("Content-Type", "application/json");
        String content = Base64.getEncoder().encodeToString(contents.getBytes(StandardCharsets.UTF_8));
        String requestBody = String.format("{\"content\":\"%s\",\"message\":\"Update %s\",\"sha\":\"%s\",\"branch\":\"%s\"}", content, fileNameWithExt, fileSha, branch);
        try (OutputStream os = connection.getOutputStream();){
            os.write(requestBody.getBytes());
            os.flush();
        }
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            log.info("File {} updated successfully.", (Object)fileNameWithExt);
            return 200;
        }
        log.error("Failed to update file. Response code: {}", (Object)responseCode);
        return responseCode;
    }

    public List<ScheduleHistoryVO> getScheduleHistory(SearchDTO searchDTO) {
        return Optional.ofNullable((List)this.engineCommunicator.getScheduleHistory(searchDTO).getBody()).orElse(Collections.emptyList());
    }

    public void retryFailedReqStatusCreationToElasticsearch() {
        this.backendCoreCommunicator.retryFailedReqStatusCreationToElasticsearch();
    }

    public void cacheStatusMappingData() {
        this.backendCoreCommunicator.cacheStatusMappingData();
    }

    public void updateArmsStateCategory() {
        this.engineCommunicator.updateArmsStateCategory();
    }

    public void cloudJiraTestApiRequest() {
        this.engineCommunicator.cloudJiraTestApiRequest();
    }

    public ScheduleServiceImpl(ScheduleMapProvider mapProvider, ScheduleTaskDispatcher dispatcher, EngineCommunicator engineCommunicator, BackendCoreCommunicator backendCoreCommunicator, SystemInfo systemInfo) {
        this.mapProvider = mapProvider;
        this.dispatcher = dispatcher;
        this.engineCommunicator = engineCommunicator;
        this.backendCoreCommunicator = backendCoreCommunicator;
        this.systemInfo = systemInfo;
    }
}

