/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.systeminfo.service;

import com.arms.api.systeminfo.model.SystemInfoFileName;
import com.arms.api.systeminfo.model.SystemInfoVO;
import com.arms.api.systeminfo.service.SystemInfo;
import com.arms.api.util.GiteaFileUtil;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="systemInfo")
public class SystemInfoImpl
implements SystemInfo {
    private static final Logger log = LoggerFactory.getLogger(SystemInfoImpl.class);
    @Value(value="${spring.cloud.config.server.git.username}")
    private String gitUsername;
    @Value(value="${spring.cloud.config.server.git.password}")
    private String gitPassword;
    @Value(value="${spring.cloud.config.server.git.default-label}")
    private String gitBranch;
    @Value(value="${gitea.system-info}")
    private String directoryUrl;
    @Value(value="${filename.system-info.base}")
    private String systemInfoBaseName;

    public SystemInfoVO getSystemInfo(Long orgLink) throws Exception {
        List yamlFiles = GiteaFileUtil.getYamlFilesFromDirectory((String)this.directoryUrl, (String)this.gitBranch, (String)this.gitUsername, (String)this.gitPassword);
        HashMap<String, String> systemInfoFileNameUrlMap = new HashMap<String, String>();
        for (String fileUrl : yamlFiles) {
            String ymlFileName = GiteaFileUtil.extractFileNameWithoutExtension((String)fileUrl);
            systemInfoFileNameUrlMap.put(ymlFileName, fileUrl);
        }
        String fileName = SystemInfoFileName.PREFIX.getNameType() + orgLink;
        if (systemInfoFileNameUrlMap.containsKey(fileName)) {
            return SystemInfoImpl.parseYamlFileToVO((String)((String)systemInfoFileNameUrlMap.get(fileName)), (String)this.gitUsername, (String)this.gitPassword);
        }
        String baseFileName = SystemInfoFileName.BASE.getNameType();
        return SystemInfoImpl.parseYamlFileToVO((String)((String)systemInfoFileNameUrlMap.get(baseFileName)), (String)this.gitUsername, (String)this.gitPassword);
    }

    private static SystemInfoVO parseYamlFileToVO(String fileUrl, String username, String password) throws Exception {
        log.info("[ SystemInfoImpl :: parseYamlFileToVO ] :: fileUrl => {}", (Object)fileUrl);
        HttpURLConnection connection = (HttpURLConnection)new URL(fileUrl).openConnection();
        String auth = username + ":" + password;
        String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
        connection.setRequestProperty("Authorization", "Basic " + encodedAuth);
        if (connection.getResponseCode() != 200) {
            throw new RuntimeException("Failed to download file: " + connection.getResponseMessage());
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            SystemInfoVO systemInfoVO = (SystemInfoVO)mapper.readValue((Reader)reader, SystemInfoVO.class);
            return systemInfoVO;
        }
    }
}

