/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.util.slack;

import com.arms.api.util.slack.SlackMessageDTO;
import com.arms.api.util.slack.SlackProperty;
import com.slack.api.Slack;
import com.slack.api.model.Attachment;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class SlackNotificationService {
    private static final Logger log = LoggerFactory.getLogger(SlackNotificationService.class);
    private static final String TOP_MESSAGE = "*[A-RMS] NOTIFICATION*";
    private static final String FOOTER_MESSAGE = "313devgrp";
    private static final String FOOTER_ICON = "http://www.313.co.kr/arms/img/313.png";
    private final SlackProperty slackProperty;
    private final Environment environment;

    public void sendMessageToChannel(SlackProperty.Channel channel, Exception e) {
        if (this.isStageOrLiveProfile()) {
            String title = MessageFormat.format("[{0}] {1}", this.slackProperty.getProfile(), this.slackProperty.getServiceName());
            String message = this.messageInStackTrace(e);
            SlackMessageDTO slackMessageDTO = this.getSlackMessageMetaDTO(title);
            List<Attachment> attachments = List.of(slackMessageDTO.parseAttachment(message));
            Slack slack = Slack.getInstance();
            try {
                slack.methods(this.slackProperty.getToken()).chatPostMessage(request -> request.channel(channel.name()).text(TOP_MESSAGE).attachments(attachments));
            }
            catch (Exception exception) {
                log.error("Failed to send Slack message: {}", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    public void sendMessageToChannel(SlackProperty.Channel channel, String message) {
        if (this.isStageOrLiveProfile()) {
            log.info("[ SlackNotificationService :: sendMessageToChannel ] :: message => {}", (Object)message);
            String title = MessageFormat.format("[{0}] {1}", this.slackProperty.getProfile(), this.slackProperty.getServiceName());
            SlackMessageDTO slackMessageDTO = this.getSlackMessageMetaDTO(title);
            List<Attachment> attachments = List.of(slackMessageDTO.parseAttachment(message));
            Slack slack = Slack.getInstance();
            try {
                slack.methods(this.slackProperty.getToken()).chatPostMessage(request -> request.channel(channel.name()).text(TOP_MESSAGE).attachments(attachments));
            }
            catch (Exception exception) {
                log.error("Failed to send Slack message: {}", (Object)exception.getMessage(), (Object)exception);
            }
        }
    }

    private String messageInStackTrace(Exception e) {
        String filteredStackTrace = Arrays.stream(e.getStackTrace()).filter(stackTraceElement -> stackTraceElement.getClassName().contains("com.arms")).map(StackTraceElement::toString).collect(Collectors.joining("\n", "\n\n[StackTrace]\n", ""));
        return String.valueOf(e) + (filteredStackTrace.isBlank() ? "" : filteredStackTrace);
    }

    private boolean isStageOrLiveProfile() {
        List<String> allowedProfiles = Arrays.asList("stg", "live");
        return Arrays.stream(this.environment.getActiveProfiles()).anyMatch(allowedProfiles::contains);
    }

    private SlackMessageDTO getSlackMessageMetaDTO(String title) {
        return SlackMessageDTO.builder().title(title).footer(FOOTER_MESSAGE).footerIcon(FOOTER_ICON).build();
    }

    public SlackNotificationService(SlackProperty slackProperty, Environment environment) {
        this.slackProperty = slackProperty;
        this.environment = environment;
    }
}

