package com.arms.api.schedule.controller;

import com.arms.api.util.aspect.SlackSendAlarm;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

@RestController
@RequestMapping("/auth-sche/api/schedule")
@RequiredArgsConstructor
@Slf4j
public class ScheduleWebhookController {

    /**
     * ContextRefresher는 내부적으로 RefreshScopeRefreshedEvent를 발생시켜,
     * @RefreshScope가 적용된 Bean을 새로 로드하고
     * @EventListener(RefreshScopeRefreshedEvent.class) 도 호출됨 (즉, onRefresh() 메서드 실행됨)
     * */
    @Qualifier("configDataContextRefresher")
    private final ContextRefresher contextRefresher;


    @PostMapping("/refresh")
    @SlackSendAlarm(messageOnEnd = "배치 스케쥴 리플레시 및 적용 완료")
    public ResponseEntity<String> refreshContext() {
        log.info("[ ScheduleWebhookController :: refreshContext ] :: refreshContext is triggered by gitea");
        Set<String> refreshedKeys = contextRefresher.refresh();
        return ResponseEntity.ok("Context refreshed. Updated keys: " + refreshedKeys);
    }
}
