package com.arms.api.schedule.util;

import com.arms.api.schedule.model.dto.ScheduleInfoDTO;
import com.arms.api.schedule.model.vo.ScheduleInfoVO;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import java.util.List;

@Slf4j
public class ScheduleFileReader {

    @SuppressWarnings("java:S2647")
    public static List<ScheduleInfoVO> readScheduleYmlFileAndParseToVO(String fileUrl, String username, String password) throws Exception {

        List<ScheduleInfoVO> scheduleInfoList = null;

        log.info("[ ScheduleFileReader :: readScheduleYmlFileAndParseToVO ] :: fileUrl => {}", fileUrl);

        try {
            HttpURLConnection connection = (HttpURLConnection) new URL(fileUrl).openConnection();
            String auth = username + ":" + password;
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            connection.setRequestProperty("Authorization", "Basic " + encodedAuth);

            int responseCode = connection.getResponseCode();
            if (responseCode == HttpURLConnection.HTTP_OK) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()))) {
                    ObjectMapper mapper = new ObjectMapper(new YAMLFactory());
                    ScheduleListWrapper wrapper = mapper.readValue(reader, ScheduleListWrapper.class);
                    scheduleInfoList = wrapper.getSchedule();
                } catch (Exception e) {
                    log.error("YAML 파싱 오류: {}", e.getMessage(), e);
                }
            } else {
                log.error("HTTP 요청 실패. 응답 코드: {}", responseCode);
            }
            connection.disconnect();
        } catch (Exception e) {
            log.error("URL 연결 오류: {}", e.getMessage(), e);
        }
        return scheduleInfoList;
    }

    @Data
    public static class ScheduleListWrapper {
        private List<ScheduleInfoVO> schedule;
    }

    public static String convertScheduleListToYaml(List<ScheduleInfoDTO> scheduleList) {
        StringBuilder yamlContent = new StringBuilder("schedule:\n");

        for (ScheduleInfoDTO scheduleInfoDTO : scheduleList) {
            yamlContent.append("  - name: \"").append(scheduleInfoDTO.getName()).append("\"\n")
//                    .append("    method-name: \"").append(scheduleInfoDTO.getMethodName()).append("\"\n")
                    .append("    cron: \"").append(scheduleInfoDTO.getCron()).append("\"\n")
                    .append("    notes: \"").append(scheduleInfoDTO.getNotes()).append("\"\n")
                    .append("    enabled: ").append(scheduleInfoDTO.getEnabled()).append("\n");
        }

        return yamlContent.toString();
    }
}
