package com.arms.api.schedule.util;

import com.arms.config.DynamicSchedulerConfig;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class ScheduleInitializer implements ApplicationListener<ApplicationReadyEvent> {

    @Autowired
    private DynamicSchedulerConfig dynamicSchedulerConfig;

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        log.info("ApplicationReadyEvent triggered. Initializing schedules...");

        // 수동으로 스케줄 등록
        try {
            log.info("onApplicationEvent :: dynamicSchedulerConfig.refreshSchedules 실행");
            dynamicSchedulerConfig.refreshSchedules();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
