package com.arms.api.systeminfo.controller;

import com.arms.api.systeminfo.service.SystemInfo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Slf4j
@Controller
@RequestMapping("/system-info")
public class SystemInfoController {

    @Autowired
    @Qualifier("systemInfo")
    private SystemInfo systemInfo;

    @GetMapping("/org-link")
    @ResponseBody
    public ResponseEntity<?> getSystemInfo(@RequestParam("orgLink") Long orgLink) throws Exception {

        log.info("[ SystemInfoController :: getSystemInfo ] :: org_link => {}", orgLink);

        return ResponseEntity.ok(systemInfo.getSystemInfo(orgLink));
    }
}
