package com.arms.egovframework.javaservice.gcframework.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.*;

@Setter
@Getter
@AllArgsConstructor
@NoArgsConstructor
public class GitFileInfo {

    private String name;
    private String path;
    private String sha;
    private String type; // "file", "dir", "submodule", "symlink"
    private long size; // bytes
    private String url;
    @JsonProperty("html_url") // JSON 필드 이름과 Java 필드 이름이 다를 경우
    private String htmlUrl;
    @JsonProperty("git_url")
    private String gitUrl;
    @JsonProperty("download_url")
    private String downloadUrl;
    private String encoding; // 보통 base64
    @JsonProperty("_links")
    private Links _links;
}
