package com.arms.egovframework.javaservice.gcframework.provider;

import com.arms.egovframework.javaservice.gcframework.model.FileContent;
import com.arms.egovframework.javaservice.gcframework.model.GitFileInfo;
import com.arms.egovframework.javaservice.gcframework.model.RepoType;

import java.util.List;

/**
 * 역할: 다양한 Git Repository (Gitea, GitHub..)에 대한 공통 인터페이스를 정의 <br/>
 * 책임: Git Repository 와의 상호작용(파일 CRUD)에 필요한 추상 메서드를 정의 <br/>
 * 예시 인터페이스: GitRepositoryProvider <br/>
 * 고려사항: 인증 방식 (Token, Username/Password) 및 API Endpoint 설정은 각 구현체에서 담당하도록 합니다.
 * 모든 Git Repository 서비스(Gitea, GitHub 등)가 구현해야 할 표준 계약을 정의합니다.
 * Git Repository에 대한 파일 목록 조회, 파일 내용 조회, 파일 생성/수정(upsert), 파일 삭제 등의 추상 메서드를 가집니다.
 **/

public interface GitRepositoryProvider {
    RepoType getType(); // "gitea", "github" 등

    List<GitFileInfo> getListFilesAndDirectories(String owner, String repoName, String directoryPath, String branch);
    FileContent getFileContent(String owner, String repoName, String branch, String filePath);
    boolean upsertFile(String owner, String repoName, String branch, String filePath, String content, String commitMessage);
    boolean deleteFile(String owner, String repoName, String branch, String filePath, String commitMessage);
}
