package com.arms.license;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;

public class LicenseSigner {
    public static void main(String[] args) throws Exception {
        String email = "user@example.com";
        String expiry = "2024-12-31";
        String data = email + "|" + expiry;

        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream("private.key"))) {
            // 개인키 로딩
            PrivateKey privateKey = (PrivateKey) ois.readObject();
            ois.close();

            // 서명 생성
            Signature signature = Signature.getInstance("SHA256withRSA");
            signature.initSign(privateKey);
            signature.update(data.getBytes("UTF-8"));
            byte[] digitalSignature = signature.sign();
            String signatureBase64 = Base64.getEncoder().encodeToString(digitalSignature);

            // license.lic 파일 생성
            try (PrintWriter out = new PrintWriter("license.lic")) {
                out.println("DATA=" + data);
                out.println("SIGNATURE=" + signatureBase64);
            }
            System.out.println("✔ 라이선스 생성 완료: license.lic");
        }
    }
}
