/*
 * Decompiled with CFR 0.152.
 */
package com.arms.api.mapping.controller;

import com.arms.api.mapping.domain.AlmIssueStatus;
import com.arms.api.mapping.domain.StateCategory;
import com.arms.api.mapping.dto.AlmServerRequestDTO;
import com.arms.api.mapping.dto.StateCategoryDTO;
import com.arms.api.mapping.dto.StateDTO;
import com.arms.api.mapping.service.AlmIssueStatusService;
import com.arms.api.mapping.service.StateCategoryService;
import com.arms.api.mapping.service.StateService;
import com.arms.api.util.redisrepo.util.RedisUtil;
import com.arms.api.util.response.CommonResponse;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/mapping"})
public class MappingController {
    private static final Logger log = LoggerFactory.getLogger(MappingController.class);
    private final StateService stateService;
    private final StateCategoryService stateCategoryService;
    private final AlmIssueStatusService almIssueStatusService;

    @PostMapping(value={"/alm/issuestatus"})
    public Mono<CommonResponse.ApiResult<String>> almIssueStatusInit(@RequestBody AlmServerRequestDTO almServerRequestDTO) {
        if (almServerRequestDTO == null) {
            throw new RuntimeException("Alm Server Data\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        String pattern = RedisUtil.getRedisHashPrefix(AlmIssueStatus.class) + ":" + this.generateDeletePattern(almServerRequestDTO.getServerId(), almServerRequestDTO.getProjectKeyOrId(), almServerRequestDTO.getIssueTypeId()) + "*";
        this.almIssueStatusService.deleteAlmIssueStatus(pattern);
        this.almIssueStatusService.initAlmIssueStatus(almServerRequestDTO.getIssueStatusDTOs().stream().map(almIssueStatusDTO -> {
            String key = this.generateKey(almServerRequestDTO.getServerId(), almServerRequestDTO.getProjectKeyOrId(), almServerRequestDTO.getIssueTypeId(), almIssueStatusDTO.getId());
            almIssueStatusDTO.setId(key);
            return almIssueStatusDTO.toEntity();
        }).collect(Collectors.toList()));
        return Mono.just((Object)CommonResponse.success((Object)"OK"));
    }

    @PostMapping(value={"/state"})
    public Mono<CommonResponse.ApiResult<String>> initState(@RequestBody List<StateDTO> stateDTOs) {
        if (stateDTOs == null) {
            throw new RuntimeException("ARMS State Data\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.stateService.deleteState();
        this.stateService.init(stateDTOs.stream().map(StateDTO::toEntity).collect(Collectors.toList()));
        return Mono.just((Object)CommonResponse.success((Object)"OK"));
    }

    @PostMapping(value={"/category"})
    public Mono<CommonResponse.ApiResult<String>> initCategory(@RequestBody List<StateCategoryDTO> stateCategoryDTOs) {
        if (stateCategoryDTOs == null) {
            throw new RuntimeException("ARMS State Category Data\uac00 \uc5c6\uc2b5\ub2c8\ub2e4.");
        }
        this.stateCategoryService.deleteStateCategory();
        this.stateCategoryService.init(stateCategoryDTOs.stream().map(StateCategoryDTO::toEntity).collect(Collectors.toList()));
        return Mono.just((Object)CommonResponse.success((Object)"OK"));
    }

    @GetMapping(value={"/category"})
    public Mono<CommonResponse.ApiResult<StateCategory>> findStateCategory(@RequestParam(value="serverId") String serverId, @RequestParam(value="projectKey", required=false) String projectKey, @RequestParam(value="issueTypeId", required=false) String issueTypeId, @RequestParam(value="issueStatusId") String issueStatusId) {
        String key = this.generateKey(serverId, projectKey, issueTypeId, issueStatusId);
        AlmIssueStatus almIssueStatus = this.almIssueStatusService.getAlmIssueStatus(key);
        String armsStateMappingId = almIssueStatus.getArmsStateMappingId();
        return Mono.just((Object)CommonResponse.success((Object)this.stateCategoryService.getArmsStateCategoryByStateId(armsStateMappingId)));
    }

    private String generateKey(String serverId, String projectKeyOrId, String issueTypeId, String issueStatusId) {
        if (serverId == null || issueStatusId == null) {
            throw new IllegalArgumentException("serverId and issueStatusId cannot be null");
        }
        if (projectKeyOrId == null && issueTypeId == null) {
            return String.format("%s-%s", serverId, issueStatusId);
        }
        return String.format("%s-%s-%s-%s", serverId, projectKeyOrId != null ? projectKeyOrId : "", issueTypeId != null ? issueTypeId : "", issueStatusId).replaceAll("-{2,}", "-").replaceAll("-$", "");
    }

    private String generateDeletePattern(String serverId, String projectKeyOrId, String issueTypeId) {
        if (serverId == null) {
            throw new IllegalArgumentException("serverId cannot be null");
        }
        if (projectKeyOrId == null && issueTypeId == null) {
            return String.format("%s", serverId);
        }
        return String.format("%s-%s-%s", serverId, projectKeyOrId != null ? projectKeyOrId : "", issueTypeId != null ? issueTypeId : "").replaceAll("-{2,}", "-").replaceAll("-$", "");
    }

    public MappingController(StateService stateService, StateCategoryService stateCategoryService, AlmIssueStatusService almIssueStatusService) {
        this.stateService = stateService;
        this.stateCategoryService = stateCategoryService;
        this.almIssueStatusService = almIssueStatusService;
    }
}

