/*
 * Decompiled with CFR 0.152.
 */
package com.arms.config.handler.component;

import com.arms.client.dwr.DwrClient;
import com.arms.config.handler.KeycloakLogoutHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.ReactiveRedisOperations;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.session.data.redis.ReactiveRedisSessionRepository;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class AuthSuccessAfterDuplicateUserRemove {
    private static final Logger log = LoggerFactory.getLogger(AuthSuccessAfterDuplicateUserRemove.class);
    private final ReactiveRedisSessionRepository reactiveRedisSessionRepository;
    private final KeycloakLogoutHandler keycloakLogoutHandler;
    private final DwrClient dwrClient;
    private static final String SESSION_KEY_PATTERN = "spring:session:sessions:";
    private static final String USER_INFO_KEY = "sessionAttr:SPRING_SECURITY_CONTEXT";

    public Mono<Void> removeSession(String currentSessionId, String preferredUsername) {
        ReactiveRedisOperations sessionRedisOperations = this.reactiveRedisSessionRepository.getSessionRedisOperations();
        return sessionRedisOperations.keys((Object)"spring:session:sessions:*").flatMap(sessionKey -> sessionRedisOperations.opsForHash().entries(sessionKey).filter(attribute -> USER_INFO_KEY.equals(attribute.getKey())).flatMap(attribute -> {
            String sessionId;
            SecurityContextImpl securityContext = (SecurityContextImpl)attribute.getValue();
            OidcUser oidcUser = (OidcUser)securityContext.getAuthentication().getPrincipal();
            if (preferredUsername.equals(oidcUser.getPreferredUsername()) && !currentSessionId.equals(sessionId = sessionKey.replace(SESSION_KEY_PATTERN, ""))) {
                this.dwrClient.sendMessage(preferredUsername + "\ub2d8 \uacfc \ub3d9\uc77c\ud55c \uacc4\uc815\uc774 \ub85c\uadf8\uc778 \ub418\uc5c8\uc2b5\ub2c8\ub2e4.");
                return this.keycloakLogoutHandler.logoutFromKeycloak(oidcUser.getIdToken().getTokenValue()).then(this.reactiveRedisSessionRepository.deleteById(sessionId));
            }
            return Mono.empty();
        })).then();
    }

    public AuthSuccessAfterDuplicateUserRemove(ReactiveRedisSessionRepository reactiveRedisSessionRepository, KeycloakLogoutHandler keycloakLogoutHandler, DwrClient dwrClient) {
        this.reactiveRedisSessionRepository = reactiveRedisSessionRepository;
        this.keycloakLogoutHandler = keycloakLogoutHandler;
        this.dwrClient = dwrClient;
    }
}

