# Contributing to drawDB

Thanks for taking the time to contribute!

The following is a set of guidelines for contributing to our project. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Table of Contents

1. [How Can I Contribute?](#how-can-i-contribute)
    - [Reporting Bugs](#reporting-bugs)
    - [Suggesting Enhancements](#suggesting-enhancements)
    - [Submitting Pull Requests](#submitting-pull-requests)
2. [Style Guides](#style-guides)
    - [Git Commit Messages](#git-commit-messages)
    - [Style Guide](#style-guide)
3. [Additional Notes](#additional-notes)
    - [Issue and Pull Request Labels](#issue-and-pull-request-labels)
    - [Getting Help](#getting-help)

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for our project. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

- Use a clear and descriptive title for the issue to identify the problem.
- Describe the exact steps which reproduce the problem in as many details as possible.
- Provide specific examples to demonstrate the steps (e.g. if you're having trouble importing a file please attach it or provide a link to it).
- Include screenshots if applicable.
- Explain which behavior you expected to see instead and why.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for our project, including completely new features and minor improvements to existing functionality.

- Use a clear and descriptive title for the issue to identify the suggestion.
- Explain why this enhancement would be useful to most users.

### Submitting Pull Requests

If you would like to implement a big feature that has not been discussed before please reach out to the maintainer on Discord at @dottle_ or send an email to drawdb@outlook.com.

Please follow these steps to have your contribution considered by the maintainers:

1. Make sure the pull request you work on is atomic. That is, it implements a single feature or fixes a single bug.
2. Fork the repository and create your branch from `main`.
3. Write clear, descriptive commit messages.
4. Ensure your code adheres to the project's style guides.
5. Create a pull request.
6. Make sure to explain what your pull request solves unless it fixes something already explained in an issue that it's linked to.
7. Explain the solution. If you implement a more involved feature explain the design decisions.

## Style Guides

### Git Commit Messages

- Use the present tense (e.g. "Add Spanish locale" not "Added Spanish locale").
- Use the imperative mood (e.g. "Move cursor to..." not "Moves cursor to...").
- Reference issues and pull requests liberally after the first line.

### Style Guide

- Format your code with Prettier.
- Ensure your code passes ESLint.
- Make sure the code base is in English, this includes comments and variable names.

## Additional Notes

### Issue and Pull Request Labels

This section lists the labels we use to help organize and identify issues and pull requests.

- `bug`: Something isn't working.
- `enhancement`: New feature or request.
- `question`: Further information is requested.
- `documentation`: Improvements or additions to documentation.
- `good first issue`: Good for newcomers.
- `help wanted`: Extra attention is needed.

### Getting Help

If you have any questions, please feel free to reach out to us through the following channels:

- [Discord](https://discord.gg/BrjZgNrmR6)
- [Email](drawdb@outlook.com)

---

Thank you for your contributions! ❤️
